/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.rule.visitors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.TemplateAware;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.junit.Assert;
import org.junit.Test;

public class RuleModelVisitorTest {
    @Test
    public void visitTemplate() {
        HashMap variableMap = new HashMap();
        RuleModelVisitor visitor = new RuleModelVisitor(variableMap);
        visitor.visit((Object)new TemplateAwareIAction());
        Assert.assertTrue((boolean)variableMap.containsKey(new InterpolationVariable("test", "Object")));
    }

    @Test
    public void visitSingleFieldConstraint() {
        HashMap variableMap = new HashMap();
        RuleModelVisitor visitor = new RuleModelVisitor(variableMap);
        SingleFieldConstraint singleFieldConstraint = new SingleFieldConstraint();
        singleFieldConstraint.setConstraintValueType(7);
        singleFieldConstraint.setFieldType("fieldType");
        singleFieldConstraint.setFieldName("fieldName");
        singleFieldConstraint.setValue("value");
        singleFieldConstraint.setOperator("==");
        visitor.visit((Object)singleFieldConstraint);
        Assert.assertEquals((long)1L, (long)variableMap.keySet().size());
        InterpolationVariable interpolationVariable = (InterpolationVariable)variableMap.keySet().iterator().next();
        Assert.assertEquals((Object)"value", (Object)interpolationVariable.getVarName());
        Assert.assertEquals((Object)"fieldName", (Object)interpolationVariable.getFactField());
        Assert.assertEquals((Object)"fieldType", (Object)interpolationVariable.getDataType());
        Assert.assertEquals((Object)"==", (Object)interpolationVariable.getOperator());
    }

    private static class TemplateAwareIAction
    implements IAction,
    TemplateAware {
        private TemplateAwareIAction() {
        }

        public Collection<InterpolationVariable> extractInterpolationVariables() {
            return Arrays.asList(new InterpolationVariable("test", "Object"));
        }

        public void substituteTemplateVariables(Function<String, String> keyToValueFunction) {
        }

        public TemplateAware cloneTemplateAware() {
            return new TemplateAwareIAction();
        }
    }
}

