/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.oracle;

import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.junit.Assert;
import org.junit.Test;

public class OperatorsOracleTest {
    @Test
    public void stringConnectives() {
        this.assertContainsAll(OperatorsOracle.STRING_CONNECTIVES, "|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >=", "&& matches", "|| matches");
    }

    @Test
    public void STANDARD_OPERATORS() {
        this.assertContainsAll(OperatorsOracle.STANDARD_OPERATORS, "==", "!=", "== null", "!= null");
    }

    @Test
    public void standardConnectives() {
        this.assertContainsAll(OperatorsOracle.STANDARD_CONNECTIVES, "|| ==", "|| !=", "&& !=");
    }

    @Test
    public void comparableOperators() {
        this.assertContainsAll(OperatorsOracle.COMPARABLE_OPERATORS, "==", "!=", "<", ">", "<=", ">=", "== null", "!= null");
    }

    @Test
    public void simpleCEPConnectives() {
        this.assertContainsAll(OperatorsOracle.SIMPLE_CEP_CONNECTIVES, "|| after", "|| before", "|| coincides", "&& after", "&& before", "&& coincides");
    }

    @Test
    public void windowCEPOperators() {
        this.assertContainsAll(OperatorsOracle.WINDOW_CEP_OPERATORS, "over window:time", "over window:length");
    }

    @Test
    public void complexCEPOperators() {
        this.assertContainsAll(OperatorsOracle.COMPLEX_CEP_OPERATORS, "during", "finishes", "finishedby", "includes", "meets", "metby", "overlaps", "overlappedby", "starts", "startedby");
    }

    @Test
    public void simpleCEPOrators() {
        this.assertContainsAll(OperatorsOracle.SIMPLE_CEP_OPERATORS, "after", "before", "coincides");
    }

    @Test
    public void conditionalElements() {
        this.assertContainsAll(OperatorsOracle.CONDITIONAL_ELEMENTS, "not", "exists", "or");
    }

    @Test
    public void complexCEPConnectives() {
        this.assertContainsAll(OperatorsOracle.COMPLEX_CEP_CONNECTIVES, "|| during", "|| finishes", "|| finishedby", "|| includes", "|| meets", "|| metby", "|| overlaps", "|| overlappedby", "|| starts", "|| startedby", "&& during", "&& finishes", "&& finishedby", "&& includes", "&& meets", "&& metby", "&& overlaps", "&& overlappedby", "&& starts", "&& startedby");
    }

    @Test
    public void comparableConnectives() {
        this.assertContainsAll(OperatorsOracle.COMPARABLE_CONNECTIVES, "|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >=");
    }

    @Test
    public void explicitListOperators() {
        this.assertContainsAll(OperatorsOracle.EXPLICIT_LIST_OPERATORS, "in", "not in");
    }

    @Test
    public void collectionOperators() {
        this.assertContainsAll(OperatorsOracle.COLLECTION_OPERATORS, "contains", "excludes", "==", "!=", "== null", "!= null");
    }

    @Test
    public void collectionConnectives() {
        this.assertContainsAll(OperatorsOracle.COLLECTION_CONNECTIVES, "|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes");
    }

    @Test
    public void stringOperators() {
        this.assertContainsAll(OperatorsOracle.STRING_OPERATORS, "==", "!=", "<", ">", "<=", ">=", "matches", "not matches", "soundslike", "not soundslike", "== null", "!= null");
    }

    public void assertContainsAll(String[] list, String ... items) {
        Assert.assertEquals((long)items.length, (long)list.length);
        for (String item : items) {
            this.assertContains(list, item);
        }
    }

    private void assertContains(String[] strings, String s) {
        for (String string : strings) {
            if (!string.equals(s)) continue;
            return;
        }
        Assert.fail((String)("Could not find " + s));
    }
}

