/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.rule.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.util.InterpolationVariableCollector;
import org.junit.Assert;
import org.junit.Test;

public class InterpolationVariableCollectorTest {
    @Test
    public void merge() {
        HashMap<InterpolationVariable, Integer> map = new HashMap<InterpolationVariable, Integer>();
        map.put(new InterpolationVariable("var", "Date", "Person", "birthday"), 1);
        map.put(new InterpolationVariable("var", "Date", "Person", "dateOfDeath"), 2);
        Map result = new InterpolationVariableCollector(map).getMap();
        Assert.assertEquals((long)1L, (long)result.size());
        InterpolationVariable var = (InterpolationVariable)result.keySet().iterator().next();
        Assert.assertEquals((Object)"var", (Object)var.getVarName());
        Assert.assertEquals((Object)"DEFAULT_TYPE", (Object)var.getDataType());
    }

    @Test
    public void orderTopDown() {
        HashMap<InterpolationVariable, Integer> map = new HashMap<InterpolationVariable, Integer>();
        map.put(new InterpolationVariable("var", "Date", "Person", "birthday"), 0);
        map.put(new InterpolationVariable("var", "Date", "Person", "dateOfDeath"), 1);
        map.put(new InterpolationVariable("p", "Date", "Person", "dateOfDeath"), 2);
        Map result = new InterpolationVariableCollector(map).getMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator iterator = result.values().iterator();
        Assert.assertEquals((long)1L, (long)((Integer)iterator.next()).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)iterator.next()).intValue());
    }

    @Test
    public void orderBottomUp() {
        HashMap<InterpolationVariable, Integer> map = new HashMap<InterpolationVariable, Integer>();
        map.put(new InterpolationVariable("var", "Date", "Person", "birthday"), 2);
        map.put(new InterpolationVariable("var", "Date", "Person", "dateOfDeath"), 1);
        map.put(new InterpolationVariable("p", "Date", "Person", "dateOfDeath"), 0);
        Map result = new InterpolationVariableCollector(map).getMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator iterator = result.values().iterator();
        Assert.assertEquals((long)0L, (long)((Integer)iterator.next()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)iterator.next()).intValue());
    }
}

