/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.NodeContainer;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubProcessHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        boolean isForCompensation;
        CompositeContextNode subProcessNode = new CompositeContextNode();
        String eventSubprocessAttribute = attrs.getValue("triggeredByEvent");
        if (eventSubprocessAttribute != null && Boolean.parseBoolean(eventSubprocessAttribute)) {
            subProcessNode = new EventSubProcessNode();
        }
        VariableScope variableScope = new VariableScope();
        subProcessNode.addContext((Context)variableScope);
        subProcessNode.setDefaultContext((Context)variableScope);
        String compensation = attrs.getValue("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            subProcessNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
        subProcessNode.setAutoComplete(true);
        return subProcessNode;
    }

    public Class generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        boolean found = false;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            Boolean isAsync = Boolean.parseBoolean((String)node.getMetaData().get("customAsync"));
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            forEachNode.setName(node.getName());
            forEachNode.setSequential(Boolean.parseBoolean(((Element)xmlNode).getAttribute("isSequential")));
            forEachNode.setAutoComplete(((CompositeContextNode)node).isAutoComplete());
            for (org.kie.api.definition.process.Node subNode : ((CompositeContextNode)node).getNodes()) {
                forEachNode.addNode(subNode);
            }
            forEachNode.setMetaData("UniqueId", ((CompositeContextNode)node).getMetaData("UniqueId"));
            forEachNode.setMetaData("BPMN.Connections", ((CompositeContextNode)node).getMetaData("BPMN.Connections"));
            VariableScope v = (VariableScope)((CompositeContextNode)node).getDefaultContext("VariableScope");
            ((VariableScope)((CompositeContextNode)forEachNode.internalGetNode(2L)).getDefaultContext("VariableScope")).setVariables(v.getVariables());
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser, isAsync);
            found = true;
            break;
        }
        if (!found) {
            this.handleCompositeContextNode(node, element, uri, localName, parser);
        }
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleCompositeContextNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        List connections = (List)compositeNode.getMetaData("BPMN.Connections");
        this.handleScript((ExtendedNodeImpl)compositeNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)compositeNode, element, "onExit");
        List throwLinks = (List)compositeNode.getMetaData("BPMN.ThrowLinks");
        ProcessHandler.linkIntermediateLinks((NodeContainer)compositeNode, throwLinks);
        ProcessHandler.linkConnections((NodeContainer)compositeNode, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)compositeNode);
        List associations = (List)compositeNode.getMetaData("BPMN.Associations");
        ProcessHandler.linkAssociations((Definitions)compositeNode.getMetaData("Definitions"), (NodeContainer)compositeNode, associations);
    }

    protected void handleForEachNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, boolean isAsync) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, this.inputAssociation);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, this.outputAssociation);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
        this.handleScript((ExtendedNodeImpl)forEachNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)forEachNode, element, "onExit");
        List connections = (List)forEachNode.getMetaData("BPMN.Connections");
        ProcessHandler.linkConnections((NodeContainer)forEachNode, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)forEachNode);
        List associations = (List)forEachNode.getMetaData("BPMN.Associations");
        ProcessHandler.linkAssociations((Definitions)forEachNode.getMetaData("Definitions"), (NodeContainer)forEachNode, associations);
        this.applyAsync(node, isAsync);
    }

    protected void applyAsync(Node node, boolean isAsync) {
        for (org.kie.api.definition.process.Node subNode : ((CompositeContextNode)node).getNodes()) {
            List incoming;
            if (!isAsync || (incoming = subNode.getIncomingConnections("DROOLS_DEFAULT")) == null) continue;
            for (Connection con : incoming) {
                if (!(con.getFrom() instanceof StartNode)) continue;
                ((Node)subNode).setMetaData("customAsync", (Object)Boolean.toString(isAsync));
                return;
            }
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

