/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.EvalHelper;

public abstract class BaseDMNTypeImpl
implements DMNType {
    private String namespace;
    private String name;
    private String id;
    private boolean collection;
    private List<UnaryTest> allowedValues;
    private DMNType baseType;
    private Type feelType;

    public BaseDMNTypeImpl(String namespace, String name, String id, boolean collection, DMNType baseType, Type feelType) {
        this.namespace = namespace;
        this.name = name;
        this.id = id;
        this.collection = collection;
        this.feelType = feelType;
        this.baseType = baseType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public Map<String, DMNType> getFields() {
        return Collections.emptyMap();
    }

    public boolean isComposite() {
        return false;
    }

    public List<DMNUnaryTest> getAllowedValues() {
        return this.allowedValues != null ? Collections.unmodifiableList(this.allowedValues) : Collections.emptyList();
    }

    public List<UnaryTest> getAllowedValuesFEEL() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<UnaryTest> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public DMNType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(DMNType baseType) {
        this.baseType = baseType;
    }

    public abstract BaseDMNTypeImpl clone();

    public void setFeelType(Type feelType) {
        this.feelType = feelType;
    }

    public Type getFeelType() {
        return this.feelType;
    }

    public String toString() {
        return "DMNType{ " + this.getNamespace() + " : " + this.getName() + " }";
    }

    public boolean isInstanceOf(Object o) {
        if (o == null) {
            return false;
        }
        if (this.isCollection() && o instanceof Collection) {
            Collection elements = (Collection)o;
            for (Object e : elements) {
                if (this.internalIsInstanceOf(e) && this.valueMatchesInUnaryTests(e)) continue;
                return false;
            }
            return true;
        }
        return this.internalIsInstanceOf(o) && this.valueMatchesInUnaryTests(o);
    }

    private boolean valueMatchesInUnaryTests(Object o) {
        if (this.allowedValues == null || this.allowedValues.isEmpty()) {
            return true;
        }
        return DMNFEELHelper.valueMatchesInUnaryTests(this.allowedValues, EvalHelper.coerceNumber((Object)o), null);
    }

    protected abstract boolean internalIsInstanceOf(Object var1);

    public boolean isAssignableValue(Object value) {
        if (value == null && this.allowedValues == null) {
            return true;
        }
        if (this.isCollection() && value instanceof Collection) {
            Collection elements = (Collection)value;
            for (Object e : elements) {
                if (this.internalIsAssignableValue(e) && this.valueMatchesInUnaryTests(e)) continue;
                return false;
            }
            return true;
        }
        return this.internalIsAssignableValue(value) && this.valueMatchesInUnaryTests(value);
    }

    protected abstract boolean internalIsAssignableValue(Object var1);
}

