/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.validation.spi.ValidationProvider;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidationProviderResolverTest
extends Arquillian {
    private static final String SERVICES_FILE = "META-INF/services/" + ValidationProvider.class.getName();

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidationProviderResolverTest.class)).build();
    }

    @Test
    @SpecAssertion(section="4.4.4.1", id="c")
    public void testServiceFileExists() {
        List<Class<?>> providers = this.readBeanValidationServiceFile();
        Assert.assertTrue((!providers.isEmpty() ? 1 : 0) != 0, (String)"There should be at least one provider");
        Assert.assertTrue((boolean)providers.contains(TestUtil.getValidationProviderUnderTest().getClass()), (String)"The validation class of the provider under test has to be in the list.");
    }

    private List<Class<?>> readBeanValidationServiceFile() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = ValidationProviderResolverTest.class.getClassLoader();
        }
        ArrayList providers = new ArrayList();
        try {
            Enumeration<URL> providerDefinitions = classloader.getResources(SERVICES_FILE);
            while (providerDefinitions.hasMoreElements()) {
                URL url = providerDefinitions.nextElement();
                this.addProviderToList(providers, url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load service file", e);
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProviderToList(List<Class<?>> providers, URL url) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        InputStream stream = url.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
            String name = reader.readLine();
            while (name != null) {
                if (!(name = name.trim()).startsWith("#")) {
                    Class<?> providerClass = ValidationProviderResolverTest.loadClass(name, ValidationProviderResolverTest.class);
                    providers.add(providerClass);
                }
                name = reader.readLine();
            }
        }
        finally {
            stream.close();
        }
    }

    private static Class<?> loadClass(String name, Class caller) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                if (caller != null) break block3;
                throw e;
            }
        }
        return Class.forName(name, true, caller.getClassLoader());
    }
}

