/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.application.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.NotNull;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.Account;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.CalendarEvent;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.CalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.ConsistentDateParameters;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.OnlineCalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.application.method.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class MethodValidationRequirementTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MethodValidationRequirementTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test
    @SpecAssertion(section="4.5.2", id="a")
    public void testMethodParameterConstraintsAreDeclaredByAnnotatingParameters() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("setType", String.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
    }

    @Test
    @SpecAssertion(section="4.5.2", id="a")
    public void testConstructorParameterConstraintsAreDeclaredByAnnotatingParameters() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(String.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
    }

    @Test
    @SpecAssertion(section="4.5.2.1", id="a")
    public void testCrossParameterConstraintsAreDeclaredByAnnotatingMethods() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[]{new Date(), new Date(new Date().getTime() - 1000L)};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, ConsistentDateParameters.class);
    }

    @Test
    @SpecAssertion(section="4.5.2.1", id="a")
    public void testCrossParameterConstraintsAreDeclaredByAnnotatingConstructors() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(Date.class, Date.class);
        Object[] parameterValues = new Object[]{new Date(), new Date(new Date().getTime() - 1000L)};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, ConsistentDateParameters.class);
    }

    @Test
    @SpecAssertion(section="4.5.2.1", id="b")
    public void testMethodParameterAndCrossParameterConstraintsAreEvaluatedAtTheSameTime() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class, Integer.class);
        Object[] parameterValues = new Object[3];
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class, ConsistentDateParameters.class);
    }

    @Test
    @SpecAssertion(section="4.5.2.1", id="b")
    public void testConstructorParameterAndCrossParameterConstraintsAreEvaluatedAtTheSameTime() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(Date.class, Date.class, Integer.class);
        Object[] parameterValues = new Object[3];
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class, ConsistentDateParameters.class);
    }

    @Test
    @SpecAssertion(section="4.5.3", id="a")
    public void testReturnValueConstraintsAreDeclaredByAnnotatingMethods() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("findEvents", String.class);
        Object returnValue = null;
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
    }

    @Test
    @SpecAssertion(section="4.5.3", id="a")
    public void testReturnValueConstraintsAreDeclaredByAnnotatingConstructors() throws Exception {
        Constructor constructor = CalendarService.class.getConstructor(new Class[0]);
        CalendarService returnValue = new CalendarService();
        Set constraintViolations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, OnlineCalendarService.class);
    }

    @Test
    @SpecAssertion(section="4.5.4", id="a")
    public void testMethodParameterIsMarkedAsCascaded() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[]{new User()};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "setUser", "arg0", "name");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="a")
    public void testConstructorParameterIsMarkedAsCascaded() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[]{new User()};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "CalendarEvent", "arg0", "name");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="a")
    public void testMethodReturnValueIsMarkedAsCascaded() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        User returnValue = new User();
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "getUser", "<return value>", "name");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="a")
    public void testConstructorReturnValueIsMarkedAsCascaded() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(String.class);
        CalendarEvent returnValue = new CalendarEvent(null, null);
        Set constraintViolations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "CalendarEvent", "<return value>", "type");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="b")
    public void testPassingNullToCascadedMethodParameterCausesNoViolation() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.5.4", id="b")
    public void testPassingNullToCascadedConstructorParameterCausesNoViolation() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[1];
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.5.4", id="b")
    public void testReturningNullFromCascadedMethodCausesNoViolation() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        Object returnValue = null;
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.5.4", id="c")
    public void testCascadedMethodParameterIsValidatedRecursively() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("setUser", User.class);
        Object[] parameterValues = new Object[]{new User(new Account())};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "setUser", "arg0", "account", "login");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="c")
    public void testCascadedConstructorParameterIsValidatedRecursively() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(User.class);
        Object[] parameterValues = new Object[]{new User(new Account())};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "CalendarEvent", "arg0", "account", "login");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="c")
    public void testCascadedMethodReturnValueIsValidatedRecursively() throws Exception {
        CalendarEvent object = new CalendarEvent();
        Method method = CalendarEvent.class.getMethod("getUser", new Class[0]);
        User returnValue = new User(new Account());
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "getUser", "<return value>", "account", "login");
    }

    @Test
    @SpecAssertion(section="4.5.4", id="c")
    public void testCascadedConstructorReturnValueIsValidatedRecursively() throws Exception {
        Constructor constructor = CalendarEvent.class.getConstructor(String.class);
        CalendarEvent returnValue = new CalendarEvent();
        Set constraintViolations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        Assert.assertNotNull((Object)constraintViolations);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath(), "CalendarEvent", "<return value>", "user", "name");
    }
}

