/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import javax.validation.ConstraintDeclarationException;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.model.Order;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.model.Person;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.AbstractCalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ExtendedOrderServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationAddingParameterConstraints;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationMarkingParameterAsCascaded;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfCascadingAndNonCascadingInterfaces;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfConstrainedAndUnconstrainedInterfaces;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.OrderServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.OrderServiceSubClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.SubClassAddingParameterConstraints;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.SubClassMarkingParameterAsCascaded;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class InvalidMethodConstraintDeclarationTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InvalidMethodConstraintDeclarationTest.class)).withPackage(ImplementationAddingParameterConstraints.class.getPackage())).withPackage(AbstractCalendarService.class.getPackage())).withPackage(Person.class.getPackage())).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="a")
    public void testParameterConstraintsAddedInInterfaceImplementationCausesException() throws Exception {
        ImplementationAddingParameterConstraints object = new ImplementationAddingParameterConstraints();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Implementing method must add no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="a")
    public void testParameterConstraintsAddedInSubClassCausesException() throws Exception {
        SubClassAddingParameterConstraints object = new SubClassAddingParameterConstraints();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Overriding subclass method must add no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="a")
    public void testParameterMarkedAsCascadedInInterfaceImplementationCausesException() throws Exception {
        ImplementationMarkingParameterAsCascaded object = new ImplementationMarkingParameterAsCascaded();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Implementing method must not mark a parameter cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="a")
    public void testParameterMarkedAsCascadedInSubClassCausesException() throws Exception {
        SubClassMarkingParameterAsCascaded object = new SubClassMarkingParameterAsCascaded();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Overriding subclass method must not mark a parameter cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="b")
    public void testConstrainedParameterInOneMethodOfParallelInterfacesCausesException() throws Exception {
        ImplementationOfConstrainedAndUnconstrainedInterfaces object = new ImplementationOfConstrainedAndUnconstrainedInterfaces();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in two parallel interfaces must have no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="b")
    public void testParameterIsConstrainedInInterfaceMethodAndSuperClassMethodCausesException() throws Exception {
        ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass object = new ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in an interface and a superclass not implementing this interface must have no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="b")
    public void testParameterIsCascadingInOneMethodOfParallelInterfacesCausesException() throws Exception {
        ImplementationOfCascadingAndNonCascadingInterfaces object = new ImplementationOfCascadingAndNonCascadingInterfaces();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in two parallel interfaces must not have no parameters marked as cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="b")
    public void testParameterIsCascadingInInterfaceMethodAndSuperClassMethodCausesException() throws Exception {
        ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass object = new ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in an interface and a superclass not implementing this interface must have no parameters marked as cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="d")
    public void testReturnValueIsMarkedAsCascadedInInterfaceAndImplementationCausesException() throws Exception {
        OrderServiceImplementation object = new OrderServiceImplementation();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"A method must not mark the return value as cascaded if the implemented interface method is cascaded, too. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="d")
    public void testReturnValueIsMarkedAsCascadedInBaseAndSubClassCausesException() throws Exception {
        OrderServiceSubClass object = new OrderServiceSubClass();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"A method must not mark the return value as cascaded if the overridden superclass method is cascaded, too. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="4.5.5", id="d")
    public void testReturnValueIsMarkedAsCascadedInSuperAndDerivedInterfaceCausesException() throws Exception {
        ExtendedOrderServiceImplementation object = new ExtendedOrderServiceImplementation();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"An interface method must not mark the return value as cascaded if the overridden superinterface method is cascaded, too. Expected exception wasn't thrown.");
    }

    private Method getCreateEventMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("createEvent", Date.class, Date.class, List.class);
    }

    private Method getPlaceOrderMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("placeOrder", String.class, Integer.TYPE);
    }
}

