/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions;

import java.lang.reflect.Method;
import java.util.Date;
import javax.validation.ConstraintDefinitionException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultGroup;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultPayload;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidGroupsType;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidMessageType;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidPayloadClass;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoGroups;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoMessage;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoPayload;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.ValidInPropertyName;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class InvalidConstraintDefinitionsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InvalidConstraintDefinitionsTest.class)).build();
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1", id="b"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithParameterStartingWithValid() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityValidProperty(), new Class[0]);
        Assert.fail((String)"The used constraint does use an invalid property name. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.1", id="a"), @SpecAssertion(section="5.3.1", id="b"), @SpecAssertion(section="5.3.1", id="c"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithoutMessageParameter() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityNoMessage(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a message parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.2", id="a"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithoutGroupParameter() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityNoGroups(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a groups parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.3", id="a"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithoutPayloadParameter() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityNoGroups(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a payload parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.2", id="c"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithWrongDefaultGroupValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityInvalidDefaultGroup(), new Class[0]);
        Assert.fail((String)"The default groups parameter is not the empty array. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.3", id="b"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithWrongDefaultPayloadValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityInvalidDefaultPayload(), new Class[0]);
        Assert.fail((String)"The default payload parameter is not the empty array. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.3", id="c"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithWrongPayloadClass() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityInvalidPayloadClass(), new Class[0]);
        Assert.fail((String)"The default payload parameter has to be of type Class<? extends Payload>[]. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.1", id="a"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithWrongMessageType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityInvalidMessageType(), new Class[0]);
        Assert.fail((String)"The message parameter has to be of type String. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="g"), @SpecAssertion(section="3.1.1.2", id="b"), @SpecAssertion(section="9.2", id="a")})
    public void testConstraintDefinitionWithWrongGroupType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyEntityInvalidGroupsType(), new Class[0]);
        Assert.fail((String)"The groups parameter has to be of type Class<?>[]. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class}, groups={"FAILING_IN_RI"})
    public void testConstraintDefinitionGenericAndCrossParameterConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new DummyGenericAndCrossParameterConstraint(), new Class[0]);
        Assert.fail((String)"A constraint may either be annotated with @Constraint or @CrossParameterConstraint, but not both. The validation should have failed.");
    }

    @Test(expectedExceptions={Exception.class})
    @SpecAssertion(section="3.4", id="g")
    public void testValidatorForCrossParameterConstraintMustValidateObjectArray() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        ExecutableValidator executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
        executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Validators for cross-parameter constraints must validate the type Object[]. Expected exception wasn't thrown.");
    }

    public static class CalendarService {
        @InvalidCrossParameterConstraint
        public void createEvent(Date start, Date end) {
        }
    }

    @GenericAndCrossParameterConstraint
    public class DummyGenericAndCrossParameterConstraint {
    }

    @InvalidGroupsType
    public class DummyEntityInvalidGroupsType {
    }

    @InvalidMessageType
    public class DummyEntityInvalidMessageType {
    }

    @InvalidPayloadClass
    public class DummyEntityInvalidPayloadClass {
    }

    @InvalidDefaultPayload
    public class DummyEntityInvalidDefaultPayload {
    }

    @NoPayload
    public class DummyEntityNoPayload {
    }

    @ValidInPropertyName
    public class DummyEntityValidProperty {
    }

    @NoMessage
    public class DummyEntityNoMessage {
    }

    @NoGroups
    public class DummyEntityNoGroups {
    }

    @InvalidDefaultGroup
    public class DummyEntityInvalidDefaultGroup {
    }
}

