/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.messageinterpolation;

import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class MessageInterpolationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(MessageInterpolationTest.class)).withResource("ValidationMessages.properties", "ValidationMessages.properties", true)).withResource("ValidationMessages_de.properties", "ValidationMessages_de.properties", true)).build();
    }

    @Test
    @SpecAssertion(section="5.3.1", id="a")
    public void testDefaultMessageInterpolatorIsNotNull() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        Assert.assertNotNull((Object)interpolator, (String)"Each bean validation provider must provide a default message interpolator.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1", id="e"), @SpecAssertion(section="5.3.1.1", id="a")})
    public void testSuccessfulInterpolationOfValidationMessagesValue() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "replacement worked";
        String actual = interpolator.interpolate("{foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "replacement worked replacement worked";
        actual = interpolator.interpolate("{foo} {foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "This replacement worked just fine";
        actual = interpolator.interpolate("This {foo} just fine", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "{} replacement worked {unknown}";
        actual = interpolator.interpolate("{} {foo} {unknown}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.1", id="b")
    public void testRecursiveMessageInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "fubar");
        TestContext context = new TestContext(descriptor);
        String expected = "recursion worked";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)expected, (String)actual, (String)"Expansion should be recursive");
    }

    @Test
    @SpecAssertion(section="5.3.1", id="d")
    public void testMessagesCanBeOverriddenAtConstraintLevel() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new DummyEntity(), "snafu", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "messages can also be overridden at constraint declaration.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1", id="f"), @SpecAssertion(section="5.3.1", id="g"), @SpecAssertion(section="5.3.1", id="h")})
    public void testLiteralCurlyBraces() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{";
        String actual = interpolator.interpolate("\\{", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "}";
        actual = interpolator.interpolate("\\}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "\\";
        actual = interpolator.interpolate("\\", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.1", id="a")
    public void testUnSuccessfulInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "foo";
        String actual = interpolator.interpolate("foo", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "#{foo  {}";
        actual = interpolator.interpolate("#{foo  {}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.1", id="a")
    public void testUnknownTokenInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{bar}";
        String actual = interpolator.interpolate("{bar}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.1", id="c")
    public void testParametersAreExtractedFromBeanValidationProviderBundle() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(Person.class, "birthday");
        TestContext context = new TestContext(descriptor);
        String key = "{javax.validation.constraints.Past.message}";
        String actual = interpolator.interpolate(key, (MessageInterpolator.Context)context);
        Assert.assertFalse((boolean)key.equals(actual), (String)"There should have been a message interpolation from the bean validator provider bundle.");
    }

    @Test
    @SpecAssertion(section="5.3.1.1", id="f")
    public void testConstraintAttributeValuesAreInterpolated() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "bar");
        TestContext context = new TestContext(descriptor);
        String expected = "size must be between 5 and 10";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.2", id="a")
    public void testMessageInterpolationWithLocale() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "kann nicht null sein";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context, Locale.GERMAN);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="5.3.1.2", id="b")
    public void testIfNoLocaleIsSpecifiedTheDefaultLocaleIsAssumed() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        String messageTemplate = (String)descriptor.getAttributes().get("message");
        TestContext context = new TestContext(descriptor);
        String messageInterpolatedWithNoLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context);
        String messageInterpolatedWithDefaultLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context, Locale.getDefault());
        Assert.assertEquals((String)messageInterpolatedWithNoLocale, (String)messageInterpolatedWithDefaultLocale, (String)"Wrong substitution");
    }

    private ConstraintDescriptor<?> getDescriptorFor(Class<?> clazz, String propertyName) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return (ConstraintDescriptor)validator.getConstraintsForClass(clazz).getConstraintsForProperty(propertyName).getConstraintDescriptors().iterator().next();
    }

    public class Person {
        String name;
        @Past
        Date birthday;
    }

    public class DummyEntity {
        @NotNull
        String foo;
        @Size(min=5, max=10, message="size must be between {min} and {max}")
        String bar;
        @Max(value=10L, message="{replace.in.user.bundle1}")
        String fubar;
        @NotNull(message="messages can also be overridden at constraint declaration.")
        String snafu;
    }

    public class TestContext
    implements MessageInterpolator.Context {
        ConstraintDescriptor<?> descriptor;

        TestContext(ConstraintDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            throw new RuntimeException("ups");
        }
    }
}

