/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.AccountChecker;
import org.hibernate.beanvalidation.tck.tests.metadata.AccountValidator;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Man;
import org.hibernate.beanvalidation.tck.tests.metadata.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.tests.metadata.Severity;
import org.hibernate.beanvalidation.tck.tests.metadata.UnconstraintEntity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class BeanDescriptorTest
extends Arquillian {
    private Validator validator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BeanDescriptorTest.class)).withClasses(Customer.class, Person.class, Man.class, Account.class, Order.class, UnconstraintEntity.class, Severity.class, NotEmpty.class, AccountChecker.class, AccountValidator.class, CustomerService.class, Executables.class)).build();
    }

    @BeforeMethod
    private void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="a")})
    public void testIsBeanConstrainedDueToValidAnnotation() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Customer.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid ");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnEntity() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Account.class);
        Assert.assertTrue((boolean)beanDescriptor.hasConstraints(), (String)"There should be direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintProperty() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Order.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @NotNull");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnInterface() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Man.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to constraints on Person.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="a")})
    public void testUnconstrainedClass() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(UnconstraintEntity.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be unconstrained.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="c")})
    public void testGetConstraintsForConstrainedProperty() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)1, (String)"There should be one constraint descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.3", id="c"), @SpecAssertion(section="6.4", id="a")})
    public void testGetConstraintsForUnConstrainedProperty() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Customer.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderList");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)0, (String)"There should be no constraint descriptors");
        Assert.assertTrue((boolean)propertyDescriptor.isCascaded(), (String)"The property should be cascaded");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="c")})
    public void testGetConstraintsForNonExistingProperty() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Order.class);
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("foobar"), (String)"There should be no descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="c")})
    public void testGetConstrainedProperties() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Order.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)1, (String)"There should be only one property");
        boolean hasOrderNumber = false;
        for (PropertyDescriptor pd : constraintProperties) {
            hasOrderNumber |= pd.getPropertyName().equals("orderNumber");
        }
        Assert.assertTrue((boolean)hasOrderNumber, (String)"Wrong property");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.1", id="a"), @SpecAssertion(section="6.3", id="c")})
    public void testGetConstrainedPropertiesForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(UnconstraintEntity.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)0, (String)"We should get the empty set.");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="6.3", id="d")
    public void testGetConstraintsForNullProperty() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Order.class);
        beanDescriptor.getConstraintsForProperty(null);
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForParameterConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.parameterConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForCrossParameterConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForCascadedParameterMethod() {
        MethodDescriptor methodDescriptor = Executables.cascadedParameterMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForReturnValueConstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.returnValueConstrainedMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForCascadedReturnValueMethod() {
        MethodDescriptor methodDescriptor = Executables.cascadedReturnValueMethod();
        Assert.assertNotNull((Object)methodDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForUnconstrainedMethod() {
        MethodDescriptor methodDescriptor = Executables.unconstrainedMethod();
        Assert.assertNull((Object)methodDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForNonExistingMethod() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(CustomerService.class);
        MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod("foo", new Class[0]);
        Assert.assertNull((Object)methodDescriptor, (String)"Descriptor should be null");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="6.3", id="e")
    public void testGetConstraintsForNullMethod() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(CustomerService.class);
        beanDescriptor.getConstraintsForMethod(null, new Class[0]);
    }

    @Test
    @SpecAssertion(section="6.3", id="f")
    public void testGetConstrainedMethods() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(CustomerService.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods();
        ArrayList<String> actualMethodNames = new ArrayList<String>();
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            actualMethodNames.add(methodDescriptor.getName());
        }
        List<String> expectedMethodNames = Arrays.asList("createCustomer", "reset", "removeCustomer", "findCustomer", "findCustomer", "updateAccount", "updateAccountStrictly", "updateCustomer");
        Collections.sort(actualMethodNames);
        Collections.sort(expectedMethodNames);
        Assert.assertEquals(actualMethodNames, expectedMethodNames);
    }

    @Test
    @SpecAssertion(section="6.3", id="f")
    public void testGetConstrainedMethodsForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(UnconstraintEntity.class);
        Set methodDescriptors = beanDescriptor.getConstrainedMethods();
        Assert.assertEquals((int)methodDescriptors.size(), (int)0, (String)"We should get the empty set.");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForParameterConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.parameterConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForCrossParameterConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForCascadedParameterConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.cascadedParameterConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForReturnValueConstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForCascadedReturnValueConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.cascadedReturnValueConstructor();
        Assert.assertNotNull((Object)constructorDescriptor, (String)"Descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForUnconstrainedConstructor() {
        ConstructorDescriptor constructorDescriptor = Executables.unconstrainedConstructor();
        Assert.assertNull((Object)constructorDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="g")
    public void testGetConstraintsForNonExistingConstructorConstructor() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(CustomerService.class);
        ConstructorDescriptor constructorDescriptor = beanDescriptor.getConstraintsForConstructor(new Class[]{Short.class});
        Assert.assertNull((Object)constructorDescriptor, (String)"Descriptor should be null");
    }

    @Test
    @SpecAssertion(section="6.3", id="h")
    public void testGetConstrainedConstructors() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(CustomerService.class);
        Set constructorDescriptors = beanDescriptor.getConstrainedConstructors();
        Set<List<Class<?>>> actualParameterTypes = this.getParameterTypes(constructorDescriptors);
        Set<List> expectedParameterTypes = TestUtil.asSet(Collections.emptyList(), Arrays.asList(String.class, String.class), Arrays.asList(Customer.class), Arrays.asList(Account.class), Arrays.asList(Integer.TYPE, Account.class), Arrays.asList(Long.TYPE), Arrays.asList(Long.TYPE, Integer.TYPE));
        Assert.assertEquals(actualParameterTypes, expectedParameterTypes, (String)"Wrong constructors");
    }

    @Test
    @SpecAssertion(section="6.3", id="h")
    public void testGetConstrainedConstructorsForUnconstrainedEntity() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(UnconstraintEntity.class);
        Set constructorDescriptors = beanDescriptor.getConstrainedConstructors();
        Assert.assertEquals((int)constructorDescriptors.size(), (int)0, (String)"We should get the empty set.");
    }

    private Set<List<Class<?>>> getParameterTypes(Set<ConstructorDescriptor> constructorDescriptors) {
        HashSet parameterTypes = new HashSet();
        for (ConstructorDescriptor constructorDescriptor : constructorDescriptors) {
            ArrayList<Class> types = new ArrayList<Class>();
            for (ParameterDescriptor parameterDescriptor : constructorDescriptor.getParameterDescriptors()) {
                types.add(parameterDescriptor.getElementClass());
            }
            parameterTypes.add(types);
        }
        return parameterTypes;
    }
}

