/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidStockItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.StockItem;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.class)).withClass(StockItem.class)).withClass(ValidStockItem.class)).withValidationXml("validation-ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.xml")).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test
    @SpecAssertion(section="5.1.2", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "arg0"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(StockItem.class.getSimpleName(), "arg0"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        StockItem createdObject = new StockItem(null);
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidStockItem.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(StockItem.class.getSimpleName(), "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }
}

