/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Customer;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Email;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidateReturnValueTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateReturnValueTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Customer.class)).withClass(Email.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.2", id="d"), @SpecAssertion(section="5.1.2", id="e"), @SpecAssertion(section="5.2", id="d"), @SpecAssertion(section="5.2", id="e")})
    public void testOneViolation() throws Exception {
        String methodName = "getAddress";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, new Class[0]);
        Object returnValue = null;
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)object);
        Assert.assertEquals((Object)violation.getRootBeanClass(), Customer.class);
    }

    @Test
    @SpecAssertion(section="5.1.2", id="e")
    public void testTwoViolations() throws Exception {
        String methodName = "getFirstName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, String.class);
        String returnValue = "S";
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Pattern.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="e")
    public void testTwoConstraintsOfSameType() throws Exception {
        String methodName = "getLastName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, CharSequence.class);
        String returnValue = "S";
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="e")
    public void testNoViolations() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getFirstName", String.class);
        String returnValue = "aaa";
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="5.1.2", id="e")
    public void testValidationWithGroup() throws Exception {
        String methodName = "getLastName";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, Long.TYPE);
        String returnValue = "S";
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{Customer.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="e")
    public void testValidationWithSeveralGroups() throws Exception {
        String methodName = "getAllData";
        Customer object = new Customer();
        Method method = Customer.class.getMethod(methodName, Date.class);
        String returnValue = "S";
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{Customer.Basic.class, Customer.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Pattern.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="5.1.2", id="d")
    public void testUnexpectedType() throws Exception {
        String methodName = "getValue";
        Email object = new Email();
        Method method = Email.class.getMethod(methodName, new Class[0]);
        String returnValue = "S";
        this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="f")
    public void testNullPassedForObjectCausesException() throws Exception {
        Object object = null;
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.executableValidator.validateReturnValue(object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="f")
    public void testNullPassedForMethodCausesException() throws Exception {
        Customer object = new Customer();
        Method method = null;
        Object returnValue = null;
        this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="f")
    public void testNullPassedForGroupsCausesException() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.executableValidator.validateReturnValue((Object)object, method, returnValue, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="f")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        Customer object = new Customer();
        Method method = Customer.class.getMethod("getAddress", new Class[0]);
        Object returnValue = null;
        this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[]{null});
    }
}

