/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint;

import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Order;
import org.testng.Assert;

public class ValidOrderValidator
implements ConstraintValidator<ValidOrder, Order> {
    private int expectedMaxInvocationCount;
    private AtomicInteger actualInvocationCount;

    public void initialize(ValidOrder constraintAnnotation) {
        this.expectedMaxInvocationCount = constraintAnnotation.expectedMaxInvocationCount();
        this.actualInvocationCount = new AtomicInteger();
    }

    public boolean isValid(Order order, ConstraintValidatorContext context) {
        int invocationCount = this.actualInvocationCount.incrementAndGet();
        if (invocationCount > this.expectedMaxInvocationCount) {
            Assert.fail((String)String.format("Constraint validator was expected to be invoked only %s times but was invoked %s times.", this.expectedMaxInvocationCount, this.actualInvocationCount));
        }
        return order == null ? true : order.getName().length() >= 5;
    }
}

