/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.traversableresolver;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Call;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.ExceptionThrowingTraversableResolver;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Gentleman;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Jacket;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Person;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.SnifferTraversableResolver;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Suit;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Trousers;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class TraversableResolverTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TraversableResolverTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.3", id="a"), @SpecAssertion(section="4.6.3", id="b"), @SpecAssertion(section="4.6.3", id="c"), @SpecAssertion(section="4.6.3", id="f"), @SpecAssertion(section="4.6.3", id="g")})
    public void testCorrectNumberOfCallsToIsReachableAndIsCascadable() {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedReachCalls.add(new Call(suit, "trousers", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Suit.class, ElementType.FIELD, new String[]{"trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Suit.class, ElementType.METHOD, new String[]{null}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Suit.class, ElementType.METHOD, new String[]{null}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Suit.class, ElementType.METHOD, new String[]{"jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)suit, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.3", id="f"), @SpecAssertion(section="4.6.3", id="g")})
    public void testCorrectNumberOfCallsToIsReachableAndIsCascadableForParameterValidation() throws Exception {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "arg0"}));
        expectedReachCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "arg0"}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "arg0"}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "arg0", "trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "arg0"}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "arg0"}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "arg0", "jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        ExecutableValidator executableValidator = factory.getValidator().forExecutables();
        Gentleman gentleman = new Gentleman();
        Method method = Gentleman.class.getMethod("wearSuit", Suit.class);
        Object[] parameterValues = new Object[]{suit};
        executableValidator.validateParameters((Object)gentleman, method, parameterValues, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.3", id="f"), @SpecAssertion(section="4.6.3", id="g")})
    public void testCorrectNumberOfCallsToIsReachableAndIsCascadableForReturnValueValidation() throws Exception {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>", "trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>"}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>", "jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        ExecutableValidator executableValidator = factory.getValidator().forExecutables();
        Gentleman gentleman = new Gentleman();
        gentleman.wearSuit(suit);
        Method method = Gentleman.class.getMethod("undress", new Class[0]);
        executableValidator.validateReturnValue((Object)gentleman, method, (Object)suit, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertion(section="4.6.3", id="d")
    public void testCustomTraversableResolverViaConfiguration() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        configuration.traversableResolver((TraversableResolver)new DummyTraversableResolver());
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Validator validator = factory.getValidator();
        Person person = new Person();
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="4.6.3", id="e")
    public void testResolverExceptionsGetWrappedInValidationException() {
        ExceptionThrowingTraversableResolver resolver = new ExceptionThrowingTraversableResolver();
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)new Suit(), new Class[0]);
    }

    private static class DummyTraversableResolver
    implements TraversableResolver {
        private DummyTraversableResolver() {
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }
    }
}

