/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.util.ArrayList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidateValueTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateValueTest.class)).withClasses(Customer.class, Person.class, Order.class, Address.class)).build();
    }

    @Test
    @SpecAssertion(section="5.1.1", id="h")
    public void testValidateValueSuccess() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", (Object)"Paris", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="5.1.1", id="h")
    public void testValidateValueFailure() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", null, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "You have to specify a city.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="h"), @SpecAssertion(section="5.2", id="d"), @SpecAssertion(section="5.2", id="e")})
    public void testValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Order.class, "orderNumber", null, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "orderNumber");
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "An order must have an order number.");
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(constraintViolation, Order.class, null, "orderNumber");
        Assert.assertEquals((Object)constraintViolation.getRootBeanClass(), Order.class, (String)"Wrong root bean class");
        Assert.assertNull((Object)constraintViolation.getRootBean());
        constraintViolations = validator.validateValue(Order.class, "orderNumber", (Object)1234, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="5.1.1", id="i")
    public void testValidateValueWithInvalidPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(Customer.class, "foobar", null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateValue(Customer.class, "FirstName", null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="5.1.1", id="i")
    public void testExistingPropertyWoConstraintsNorCascaded() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(Customer.class, "middleName", new ArrayList(), new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="i")
    public void testValidateValuePassingNullAsGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(Customer.class, "firstName", (Object)"foobar", new Class[]{null});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="i")
    public void testValidateValueWithEmptyPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(Customer.class, "", null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="i")
    public void testValidateValueWithNullObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(null, "firstName", (Object)"foobar", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="i")
    public void testValidateValueWithNullPropertyName() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(Customer.class, null, (Object)"foobar", new Class[0]);
    }

    @Test
    @SpecAssertion(section="5.1.1", id="j")
    public void testValidIsNotHonoredValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validateValue(Customer.class, "orders", (Object)order, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }
}

