/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validatorfactory;

import javax.validation.Configuration;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraint;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraintValidator;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MySecondConstraint;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class CustomConstraintValidatorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CustomConstraintValidatorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="3.5", id="b")
    public void testDefaultConstructorInValidatorCalled() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Dummy(), new Class[0]);
        Assert.assertTrue((boolean)MyConstraintValidator.defaultConstructorCalled, (String)"The no-arg default constructor should have been called.");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.5", id="c")
    public void testRuntimeExceptionInValidatorCreationIsWrapped() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.5", id="d")
    public void testValidationExceptionIsThrownInCaseFactoryReturnsNull() {
        Configuration config = TestUtil.getConfigurationUnderTest().constraintValidatorFactory(new ConstraintValidatorFactory(){

            public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
                return null;
            }

            public void releaseInstance(ConstraintValidator<?, ?> instance) {
            }
        });
        Validator validator = config.buildValidatorFactory().getValidator();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    public static class SecondDummy {
        @MySecondConstraint
        public int value;
    }

    public static class Dummy {
        @MyConstraint
        public int value;
    }
}

