/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import java.io.InputStream;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserInformation;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CustomConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Error;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Order;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.OrderLine;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.TestGroup;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.UserType;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class XmlConfigurationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(XmlConfigurationTest.class)).withClasses(User.class, UserType.class, Error.class, ConsistentUserInformation.class, ConsistentUserValidator.class, CustomConsistentUserValidator.class, Optional.class, Order.class, OrderLine.class, CreditCard.class, TestGroup.class)).withValidationXml("validation-XmlConfigurationTest.xml")).withResource("user-constraints.xml")).withResource("order-constraints.xml")).withResource("order-constraints-XmlConfigurationTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testClassConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Message from xml");
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Set payloads = constraintViolation.getConstraintDescriptor().getPayload();
        Assert.assertTrue((payloads.size() == 1 ? 1 : 0) != 0, (String)"One one payload class is defined in xml");
        Assert.assertTrue((boolean)Error.class.equals(payloads.iterator().next()));
        user.setConsistent(true);
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testIgnoreValidationXml() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Validator validator = config.ignoreXmlConfiguration().buildValidatorFactory().getValidator();
        Order order = new Order();
        Set constraintViolations = validator.validate((Object)order, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testPropertyConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfeschlegelsteinhausenbergerdorff");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Size is limited!");
        user.setFirstname("Wolfgang");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testFieldConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfgang");
        user.setLastname("doe");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Last name has to start with with a capital letter.");
        user.setLastname("Doe");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testAnnotationDefinedConstraintApplies() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setPhoneNumber("police");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "A phone number can only contain numbers, whitespaces and dashes.");
        user.setPhoneNumber("112");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="a"), @SpecAssertion(section="5.5.6", id="m"), @SpecAssertion(section="5.5.6", id="l"), @SpecAssertion(section="8.1.1", id="a"), @SpecAssertion(section="8.1.1", id="b"), @SpecAssertion(section="8.1.2", id="a")})
    public void testCascadingConfiguredInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        CreditCard card = new CreditCard();
        card.setNumber("not a number");
        user.setCreditcard(card);
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Not a credit card number.");
        card.setNumber("1234567890");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="5.5.6", id="n")
    public void testMappingFilesAddedViaConfigurationGetAddedToXmlConfiguredMappings() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertFalse((boolean)validator.getConstraintsForClass(Order.class).isBeanConstrained(), (String)"Without additional mapping Order should be unconstrained");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(this.getStream("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/order-constraints-XmlConfigurationTest.xml"));
        validator = config.buildValidatorFactory().getValidator();
        Assert.assertTrue((boolean)validator.getConstraintsForClass(Order.class).isBeanConstrained(), (String)"With additional mapping Order should be constrained");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.6", id="c"), @SpecAssertion(section="8.1.1.6", id="d"), @SpecAssertion(section="8.1.1.6", id="e"), @SpecAssertion(section="8.1.1.6", id="f"), @SpecAssertion(section="8.1.1.6", id="g")})
    public void testElementConversionInXmlConfiguredConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        Set constraintDescriptors = beanDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        ConsistentUserInformation constraintAnnotation = (ConsistentUserInformation)descriptor.getAnnotation();
        Assert.assertEquals((String)constraintAnnotation.stringParam(), (String)"foobar", (String)"Wrong parameter value");
        Assert.assertEquals(constraintAnnotation.classParam(), String.class, (String)"Wrong parameter value");
        Assert.assertEquals((Object)((Object)constraintAnnotation.userType()), (Object)((Object)UserType.SELLER), (String)"Wrong parameter value");
        Assert.assertEquals((Object[])constraintAnnotation.stringArrayParam(), (Object[])new String[]{"foo", "bar"}, (String)"Wrong parameter value");
        Assert.assertEquals((long)constraintAnnotation.max().value(), (long)10L, (String)"Wrong parameter value. Default should be used");
        Assert.assertEquals((int)constraintAnnotation.patterns().length, (int)2, (String)"Wrong array size");
    }

    private InputStream getStream(String fileName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
    }
}

