/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Bar;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.BaseClass;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ConstraintWithTwoValidatorsForTheSameType;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Coordinate;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithObjectArrayValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithObjectValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithSeveralValidators;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithoutValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CustomConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Foo;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.MinMax;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SerializableBarSubclass;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassA;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassB;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Suburb;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidInteger;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidIntegerArray;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidLong;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidLongArray;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidatorResolutionTest {
    private Validator validator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ValidatorResolutionTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
    }

    @Test
    @SpecAssertion(section="4.6.4", id="b")
    public void testTargetTypeIsInterface() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomInterface.callCounter, (int)0, (String)"The validate method of ValidatorForCustomInterface should not have been called yet.");
        this.validator.validate((Object)new CustomInterfaceImpl(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomInterface.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomInterface should have been called.");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="b")
    public void testTargetTypeIsClass() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomClass.callCounter, (int)0, (String)"The validate method of ValidatorForCustomClass should not have been called yet.");
        this.validator.validate((Object)new CustomClass(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomClass.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomClass should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="c"), @SpecAssertion(section="4.6.4", id="j")})
    public void testTargetedTypeIsField() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassA.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassA should not have been called yet.");
        this.validator.validate((Object)new SubClassAHolder(new SubClassA()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassA.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassA should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="d"), @SpecAssertion(section="4.6.4", id="j")})
    public void testTargetedTypeIsGetter() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassB.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassB should not have been called yet.");
        this.validator.validate((Object)new SubClassBHolder(new SubClassB()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassB.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassB should have been called.");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="j")
    public void testClassLevelValidatorForSubTypeHasPredenceOverValidatorForSuperClass() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForAnotherSubClass.callCounter, (int)0, (String)"The validate method of ValidatorForAnotherSubClass should not have been called yet.");
        this.validator.validate((Object)new AnotherSubClass(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForAnotherSubClass.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForAnotherSubClass should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="e")})
    public void testResolutionOfMultipleSizeValidators() {
        Suburb suburb = new Suburb();
        Set constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.setName("");
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, "", "name");
        suburb.setName("Hoegsbo");
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.addFacility(Suburb.Facility.SHOPPING_MALL, false);
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getFacilities(), "facilities");
        suburb.addFacility(Suburb.Facility.BUS_TERMINAL, true);
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.addStreetName("Sikelsgatan");
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getStreetNames(), "streetNames");
        suburb.addStreetName("Marklandsgatan");
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        Coordinate[] boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getBoundingBox(), "boundingBox");
        boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L), new Coordinate(1L, 1L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = this.validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="e")})
    public void testResolutionOfMinMaxForDifferentTypes() {
        MinMax minMax = new MinMax("5", 5);
        Set constraintViolations = this.validator.validate((Object)minMax, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "number", "numberAsString");
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="h"), @SpecAssertion(section="3.1", id="e"), @SpecAssertion(section="3.4", id="l")})
    public void testUnexpectedTypeInValidatorResolution() {
        Bar bar = new Bar();
        this.validator.validate((Object)bar, new Class[0]);
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.6.4", id="k"), @SpecAssertion(section="9.3", id="b")})
    public void testAmbiguousValidatorResolution() {
        Foo foo = new Foo(new SerializableBarSubclass());
        this.validator.validate((Object)foo, new Class[0]);
        Assert.fail((String)"The test should have failed due to ambiguous validator resolution.");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="g")
    public void testValidatorForWrapperTypeIsAppliedForPrimitiveType() {
        PrimitiveHolder primitiveHolder = new PrimitiveHolder();
        Set violations = this.validator.validate((Object)primitiveHolder, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, ValidInteger.class, ValidLong.class);
    }

    @Test(groups={"FAILING_IN_RI"})
    @SpecAssertion(section="4.6.4", id="g")
    public void testValidatorForWrapperTypeArrayIsAppliedForPrimitiveTypeArray() {
        PrimitiveArrayHolder primitiveHolder = new PrimitiveArrayHolder();
        Set violations = this.validator.validate((Object)primitiveHolder, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, ValidIntegerArray.class, ValidLongArray.class);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="4.6.4", id="a")
    public void testSeveralCrossParameterValidatorsCauseConstraintDefinitionException() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="4.6.4", id="a")
    public void testCrossParameterConstraintWithoutValidatorCausesConstraintDefinitionException() throws Exception {
        OnlineCalendarService object = new OnlineCalendarService();
        Method method = OnlineCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test
    @SpecAssertion(section="4.6.4", id="a")
    public void testCrossParameterValidatorIsUsedForConstraintImplicitlyTargetingParameters() throws Exception {
        OfflineCalendarService object = new OfflineCalendarService();
        Method method = OfflineCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by cross-parameter validator");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="a")
    public void testCrossParameterValidatorIsUsedForConstraintExplicitlyTargetingParameters() throws Exception {
        AdvancedCalendarService object = new AdvancedCalendarService();
        Method method = AdvancedCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by cross-parameter validator");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="g"), @SpecAssertion(section="4.6.4", id="a")})
    public void testCrossParameterValidatorValidatingObjectArray() throws Exception {
        YetAnotherCalendarService object = new YetAnotherCalendarService();
        Method method = YetAnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by validator for Object[]");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="g"), @SpecAssertion(section="4.6.4", id="a")})
    public void testCrossParameterValidatorValidatingObject() throws Exception {
        EvenYetAnotherCalendarService object = new EvenYetAnotherCalendarService();
        Method method = EvenYetAnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.validator.forExecutables().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by validator for Object");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="f")
    public void testGenericValidatorIsUsedForConstraintTargetingMethodReturnValue() throws Exception {
        AnotherCalendarService object = new AnotherCalendarService();
        Method method = AnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object returnValue = null;
        Set violations = this.validator.forExecutables().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by generic validator");
    }

    @Test
    @SpecAssertion(section="4.6.4", id="f")
    public void testGenericValidatorIsUsedForConstraintTargetingField() {
        Set violations = this.validator.validate((Object)new TestBean(), new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "violation created by generic validator");
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertion(section="4.6.4", id="k")
    public void testTwoValidatorsForSameTypeCauseUnexpectedTypeException() {
        this.validator.validate((Object)new AnotherBean(), new Class[0]);
    }

    @ConstraintWithTwoValidatorsForTheSameType
    private static class AnotherBean {
        private AnotherBean() {
        }
    }

    private static class TestBean {
        @GenericAndCrossParameterConstraint
        public String foo;

        private TestBean() {
        }
    }

    private static class EvenYetAnotherCalendarService {
        private EvenYetAnotherCalendarService() {
        }

        @CrossParameterConstraintWithObjectValidator
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class YetAnotherCalendarService {
        private YetAnotherCalendarService() {
        }

        @CrossParameterConstraintWithObjectArrayValidator
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class AnotherCalendarService {
        private AnotherCalendarService() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        public Object createEvent(Date startDate, Date endDate) {
            return null;
        }
    }

    private static class AdvancedCalendarService {
        private AdvancedCalendarService() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object createEvent(Date startDate, Date endDate) {
            return null;
        }
    }

    private static class OfflineCalendarService {
        private OfflineCalendarService() {
        }

        @GenericAndCrossParameterConstraint
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class OnlineCalendarService {
        private OnlineCalendarService() {
        }

        @CrossParameterConstraintWithoutValidator(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class CalendarService {
        private CalendarService() {
        }

        @CrossParameterConstraintWithSeveralValidators
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class PrimitiveArrayHolder {
        @ValidIntegerArray
        private int[] ints;
        @ValidLongArray
        private long[] longs;

        private PrimitiveArrayHolder() {
        }
    }

    private static class PrimitiveHolder {
        @ValidInteger
        private int intValue;
        @ValidLong
        private long longValue;

        private PrimitiveHolder() {
        }
    }

    @CustomConstraint
    static class AnotherSubClass
    extends AnotherBaseClass {
        AnotherSubClass() {
        }
    }

    static class AnotherBaseClass {
        AnotherBaseClass() {
        }
    }

    private static class CustomInterfaceImpl
    implements CustomInterface {
        private CustomInterfaceImpl() {
        }
    }

    @CustomConstraint
    static interface CustomInterface {
    }

    @CustomConstraint
    static class CustomClass {
        CustomClass() {
        }
    }

    private static class SubClassBHolder {
        private final BaseClass baseClass;

        public SubClassBHolder(SubClassB subClass) {
            this.baseClass = subClass;
        }

        @CustomConstraint
        public SubClassB getBaseClass() {
            return (SubClassB)this.baseClass;
        }
    }

    private static class SubClassAHolder {
        @CustomConstraint
        private final SubClassA subClass;

        SubClassAHolder(SubClassA subClass) {
            this.subClass = subClass;
        }
    }
}

