/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.executable;

import java.util.Calendar;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.constraints.Future;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.AnnotatedCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.CalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ClassLevelAnnotatedCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.CrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.Event;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.Order;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.OrderService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.PersonService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.UserService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ValidPersonService;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ExecutableValidationTest
extends Arquillian {
    @Inject
    private CalendarService calendar;
    @Inject
    private AnnotatedCalendarService annotatedCalendar;
    @Inject
    private ClassLevelAnnotatedCalendarService classsLevelAnnotatedCalendar;
    @Inject
    private Instance<UserService> userServiceInstance;
    @Inject
    private Instance<PersonService> personServiceInstance;
    @Inject
    private OrderService orderService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExecutableValidationTest.class)).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.2", id="a"), @SpecAssertion(section="10.1.2", id="b"), @SpecAssertion(section="10.1.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testParameterValidationOfConstrainedMethod() {
        try {
            Calendar endDate = Calendar.getInstance();
            endDate.set(1980, 1, 1);
            this.calendar.createEvent(null, endDate.getTime());
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class, Future.class, CrossParameterConstraint.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.2", id="a"), @SpecAssertion(section="10.1.2", id="b"), @SpecAssertion(section="10.1.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testReturnValueValidationOfConstrainedMethod() {
        try {
            this.calendar.createEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.2", id="a"), @SpecAssertion(section="10.1.2", id="b"), @SpecAssertion(section="10.1.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testGettersAreNotValidatedByDefault() {
        Event event = this.calendar.getEvent();
        Assert.assertNull((Object)event, (String)"The event should be null, since getters are not validated by default.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.2", id="a"), @SpecAssertion(section="10.1.2", id="b"), @SpecAssertion(section="10.1.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testParameterValidationOfConstrainedConstructor() {
        try {
            this.userServiceInstance.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Size.class, CrossParameterConstraint.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.2", id="a"), @SpecAssertion(section="10.1.2", id="b"), @SpecAssertion(section="10.1.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testReturnValueValidationOfConstrainedConstructor() {
        try {
            this.personServiceInstance.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), ValidPersonService.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="e")
    public void testValidationOfConstrainedMethodAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.annotatedCalendar.createEvent(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="e")
    public void testValidationOfConstrainedMethodAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Event event = this.annotatedCalendar.createEvent(-10);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="f")
    public void testValidationOfConstrainedMethodOnClassAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.classsLevelAnnotatedCalendar.getEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="f")
    public void testValidationOfConstrainedMethodOnClassAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Event event = this.classsLevelAnnotatedCalendar.createEvent(null);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="f")
    public void testValidationOfConstrainedMethodOnInterfaceAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.orderService.getOrder();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="f")
    public void testValidationOfConstrainedMethodOnInterfaceAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Order order = this.orderService.placeOrder(null);
        Assert.assertNotNull((Object)order);
    }
}

