/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.factory;

import java.util.Set;
import javax.inject.Inject;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.factory.GreetingConstraint;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConstraintValidatorInjectionTest
extends Arquillian {
    @Inject
    private ValidatorFactory defaultValidatorFactory;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintValidatorInjectionTest.class)).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.1", id="b"), @SpecAssertion(section="10.3", id="a")})
    public void testDependencyInjectionIntoConstraintValidator() {
        Set violations = this.defaultValidatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "Hello, bar!", "Good morning, qux!");
    }

    private static class Foo {
        @GreetingConstraint(name="bar")
        public String bar;
        @GreetingConstraint(name="qux")
        public Integer qux;

        private Foo() {
        }
    }
}

