/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.managedobjects;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.managedobjects.GreetingConstraintValidator;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.managedobjects.MessageHolder;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ManagedObjectsTest
extends Arquillian {
    @Inject
    private ValidatorFactory defaultValidatorFactory;
    @Inject
    private Validator defaultValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ManagedObjectsTest.class)).withValidationXml("validation-ManagedObjectsTest.xml")).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.1", id="c"), @SpecAssertion(section="10.3.2", id="a"), @SpecAssertion(section="10.3", id="a")})
    public void testMessageInterpolatorIsSubjectToDependencyInjection() {
        Assert.assertNotNull((Object)this.defaultValidatorFactory);
        MessageInterpolator messageInterpolator = this.defaultValidatorFactory.getMessageInterpolator();
        Assert.assertEquals((String)messageInterpolator.interpolate(null, null), (String)"Hello from Greeter!");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.1", id="c"), @SpecAssertion(section="10.3.2", id="a"), @SpecAssertion(section="10.3", id="a")})
    public void testTraversableResolverIsSubjectToDependencyInjection() {
        Assert.assertNotNull((Object)this.defaultValidatorFactory);
        TraversableResolver traversableResolver = this.defaultValidatorFactory.getTraversableResolver();
        MessageHolder message = new MessageHolder();
        traversableResolver.isCascadable((Object)message, null, null, null, null);
        Assert.assertEquals((String)message.getValue(), (String)"Hello from Greeter!");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.1", id="c"), @SpecAssertion(section="10.3.2", id="a"), @SpecAssertion(section="10.3", id="a")})
    public void testConstraintValidatorFactoryIsSubjectToDependencyInjection() {
        Assert.assertNotNull((Object)this.defaultValidatorFactory);
        ConstraintValidatorFactory constraintValidatorFactory = this.defaultValidatorFactory.getConstraintValidatorFactory();
        GreetingConstraintValidator validator = (GreetingConstraintValidator)constraintValidatorFactory.getInstance(GreetingConstraintValidator.class);
        Assert.assertEquals((String)validator.getMessage(), (String)"Hello from Greeter!");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.1.1", id="c"), @SpecAssertion(section="10.3.2", id="a"), @SpecAssertion(section="10.3", id="a")})
    public void testParameterNameProviderIsSubjectToDependencyInjection() {
        Assert.assertNotNull((Object)this.defaultValidatorFactory);
        ParameterNameProvider parameterNameProvider = this.defaultValidatorFactory.getParameterNameProvider();
        Assert.assertEquals((Collection)parameterNameProvider.getParameterNames((Constructor)null), Arrays.asList("Hello from Greeter!"));
    }
}

