/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.ValidationException;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidBusinessCustomer;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidCustomer;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Customer;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Email;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.OrderLine;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidateConstructorReturnValueTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateConstructorReturnValueTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Customer.class)).withClass(Email.class)).withClass(Item.class)).withClass(OrderLine.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.2", id="j"), @SpecAssertion(section="5.1.2", id="k"), @SpecAssertion(section="5.2", id="d"), @SpecAssertion(section="5.2", id="e"), @SpecAssertion(section="5.2", id="f"), @SpecAssertion(section="5.2", id="g"), @SpecAssertion(section="5.2", id="h"), @SpecAssertion(section="5.2", id="i")})
    public void testOneViolation() throws Exception {
        Constructor constructor = Customer.class.getConstructor(new Class[0]);
        Customer returnValue = new Customer();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, ValidCustomer.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names("Customer", "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertNull((Object)violation.getRootBean());
        Assert.assertEquals((Object)violation.getRootBeanClass(), Customer.class);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)returnValue);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)returnValue);
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertEquals((Object)violation.getExecutableReturnValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="5.1.2", id="k")
    public void testTwoViolations() throws Exception {
        Constructor constructor = Customer.class.getConstructor(String.class);
        Customer returnValue = new Customer();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, ValidCustomer.class, ValidBusinessCustomer.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names("Customer", "<return value>"), TestUtil.names("Customer", "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="k")
    public void testTwoConstraintsOfSameType() throws Exception {
        Constructor constructor = Customer.class.getConstructor(CharSequence.class);
        Customer returnValue = new Customer();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, ValidCustomer.class, ValidCustomer.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names("Customer", "<return value>"), TestUtil.names("Customer", "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="k")
    public void testNoViolations() throws Exception {
        Constructor constructor = Customer.class.getConstructor(new Class[0]);
        Customer returnValue = new Customer("Bob");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="5.1.2", id="k")
    public void testValidationWithGroup() throws Exception {
        Constructor constructor = Customer.class.getConstructor(Long.TYPE);
        Customer returnValue = new Customer();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{Customer.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidCustomer.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names("Customer", "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="5.1.2", id="k")
    public void testValidationWithSeveralGroups() throws Exception {
        Constructor constructor = Customer.class.getConstructor(Date.class);
        Customer returnValue = new Customer();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{Customer.Basic.class, Customer.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidCustomer.class, ValidBusinessCustomer.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names("Customer", "<return value>"), TestUtil.names("Customer", "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="5.1.2", id="j")
    public void testUnexpectedType() throws Exception {
        Constructor constructor = Email.class.getConstructor(new Class[0]);
        Email returnValue = new Email();
        this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="l")
    public void testNullPassedForConstructorCausesException() throws Exception {
        Constructor constructor = null;
        Customer returnValue = new Customer();
        this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="l")
    public void testNullPassedForReturnValueCausesException() throws Exception {
        Constructor constructor = Customer.class.getConstructor(new Class[0]);
        Object returnValue = null;
        this.executableValidator.validateConstructorReturnValue(constructor, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="l")
    public void testNullPassedForGroupsCausesException() throws Exception {
        Constructor constructor = Customer.class.getConstructor(new Class[0]);
        Customer returnValue = new Customer();
        this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.2", id="l")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        Constructor constructor = Customer.class.getConstructor(new Class[0]);
        Customer returnValue = new Customer();
        this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="f"), @SpecAssertion(section="5.2", id="g"), @SpecAssertion(section="5.2", id="h"), @SpecAssertion(section="5.2", id="i")})
    public void testOneViolationForCascadedValidation() throws Exception {
        Item leaf = new Item("foo");
        OrderLine createdObject = new OrderLine(leaf);
        Constructor constructor = OrderLine.class.getConstructor(Item.class);
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)leaf);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"foo");
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertEquals((Object)violation.getExecutableReturnValue(), (Object)createdObject);
    }
}

