/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ParameterNameProvider;
import javax.validation.Payload;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.validation.CustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.util.PathUtil;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class CustomPropertyPathTest
extends Arquillian {
    private Validator validator;
    private ExecutableValidator executableValidator;

    @BeforeMethod
    public void setupValidators() {
        this.validator = TestUtil.getValidatorUnderTest();
        this.executableValidator = this.validator.forExecutables();
    }

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(CustomPropertyPathTest.class)).withClass(CustomParameterNameProvider.class)).withClass(PathUtil.class)).build();
    }

    @Test
    @SpecAssertion(section="5.2", id="an")
    public void testAddPropertyNode() {
        Set constraintViolations = this.validator.validate((Object)new Foo(), new Class[0]);
        PathUtil.assertViolationsContainOnlyPaths(constraintViolations, PathUtil.pathWith().property("myNode1"), PathUtil.pathWith().property("myNode2").property("myNode3"), PathUtil.pathWith().property("myNode4").property("myNode5", true, null, null), PathUtil.pathWith().property("myNode6").property("myNode7", true, null, 42), PathUtil.pathWith().property("myNode8").property("myNode9", true, "Foo", null), PathUtil.pathWith().property("myNode10").property("myNode11", true, null, null).property("myNode12"));
    }

    @Test
    @SpecAssertion(section="5.2", id="an")
    public void testAddBeanNode() {
        Set constraintViolations = this.validator.validate((Object)new User(), new Class[0]);
        PathUtil.assertViolationsContainOnlyPaths(constraintViolations, PathUtil.pathWith().property("address").bean(), PathUtil.pathWith().property("address").property("myNode1").bean(), PathUtil.pathWith().property("address").property("myNode2", true, null, null).bean(), PathUtil.pathWith().property("address").property("myNode3", true, null, 84).bean(), PathUtil.pathWith().property("address").property("myNode4", true, "AnotherKey", null).bean(), PathUtil.pathWith().property("address").bean(true, null, null), PathUtil.pathWith().property("address").bean(true, null, 42), PathUtil.pathWith().property("address").bean(true, "Key", null));
    }

    @Test
    @SpecAssertion(section="5.2", id="an")
    public void testAddingNodesInClassLevelConstraintKeepsInIterableKeyAndIndex() {
        Set constraintViolations = this.validator.validate((Object)new FooContainer(), new Class[0]);
        PathUtil.assertViolationsContainOnlyPaths(constraintViolations, PathUtil.pathWith().property("fooList").property("myNode1", true, null, 1), PathUtil.pathWith().property("fooList").property("myNode2", true, null, 1).property("myNode3"), PathUtil.pathWith().property("fooList").property("myNode4", true, null, 1).property("myNode5", true, null, null), PathUtil.pathWith().property("fooList").property("myNode6", true, null, 1).property("myNode7", true, null, 42), PathUtil.pathWith().property("fooList").property("myNode8", true, null, 1).property("myNode9", true, "Foo", null), PathUtil.pathWith().property("fooList").property("myNode10", true, null, 1).property("myNode11", true, null, null).property("myNode12"), PathUtil.pathWith().property("fooArray").property("myNode1", true, null, 1), PathUtil.pathWith().property("fooArray").property("myNode2", true, null, 1).property("myNode3"), PathUtil.pathWith().property("fooArray").property("myNode4", true, null, 1).property("myNode5", true, null, null), PathUtil.pathWith().property("fooArray").property("myNode6", true, null, 1).property("myNode7", true, null, 42), PathUtil.pathWith().property("fooArray").property("myNode8", true, null, 1).property("myNode9", true, "Foo", null), PathUtil.pathWith().property("fooArray").property("myNode10", true, null, 1).property("myNode11", true, null, null).property("myNode12"), PathUtil.pathWith().property("fooSet").property("myNode1", true, null, null), PathUtil.pathWith().property("fooSet").property("myNode2", true, null, null).property("myNode3"), PathUtil.pathWith().property("fooSet").property("myNode4", true, null, null).property("myNode5", true, null, null), PathUtil.pathWith().property("fooSet").property("myNode6", true, null, null).property("myNode7", true, null, 42), PathUtil.pathWith().property("fooSet").property("myNode8", true, null, null).property("myNode9", true, "Foo", null), PathUtil.pathWith().property("fooSet").property("myNode10", true, null, null).property("myNode11", true, null, null).property("myNode12"), PathUtil.pathWith().property("fooMap").property("myNode1", true, "MapKey", null), PathUtil.pathWith().property("fooMap").property("myNode2", true, "MapKey", null).property("myNode3"), PathUtil.pathWith().property("fooMap").property("myNode4", true, "MapKey", null).property("myNode5", true, null, null), PathUtil.pathWith().property("fooMap").property("myNode6", true, "MapKey", null).property("myNode7", true, null, 42), PathUtil.pathWith().property("fooMap").property("myNode8", true, "MapKey", null).property("myNode9", true, "Foo", null), PathUtil.pathWith().property("fooMap").property("myNode10", true, "MapKey", null).property("myNode11", true, null, null).property("myNode12"));
    }

    @Test
    @SpecAssertion(section="5.2", id="an")
    public void testAddParameterNode() throws Exception {
        Set constraintViolations = this.executableValidator.validateParameters((Object)new User(), User.class.getMethod("setAddresses", Map.class), new Object[0], new Class[0]);
        PathUtil.assertViolationsContainOnlyPaths(constraintViolations, PathUtil.pathWith().method("setAddresses").parameter("arg0", 0), PathUtil.pathWith().method("setAddresses").parameter("arg0", 0).bean(), PathUtil.pathWith().method("setAddresses").parameter("arg0", 0).property("myNode1", true, null, 23).bean());
    }

    @Test
    @SpecAssertion(section="5.2", id="an")
    public void testAddParameterNodeUsingCustomParameterNameProvider() throws Exception {
        ExecutableValidator executableValidator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).buildValidatorFactory().getValidator().forExecutables();
        Set constraintViolations = executableValidator.validateParameters((Object)new User(), User.class.getMethod("setAddresses", Map.class), new Object[0], new Class[0]);
        PathUtil.assertViolationsContainOnlyPaths(constraintViolations, PathUtil.pathWith().method("setAddresses").parameter("param0", 0), PathUtil.pathWith().method("setAddresses").parameter("param0", 0).bean(), PathUtil.pathWith().method("setAddresses").parameter("param0", 0).property("myNode1", true, null, 23).bean());
    }

    @Test(expectedExceptions={Exception.class})
    @SpecAssertion(section="5.2", id="an")
    public void testAddParameterNodeForFieldLevelConstraintCausesException() throws Throwable {
        this.validator.validate((Object)new Bar(), new Class[0]);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface FieldLevelValidationAddingParameterNode {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<FieldLevelValidationAddingParameterNode, String> {
            public void initialize(FieldLevelValidationAddingParameterNode constraintAnnotation) {
            }

            public boolean isValid(String value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface CrossParameterValidationAddingParameterBeanAndPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
        public static class Validator
        implements ConstraintValidator<CrossParameterValidationAddingParameterBeanAndPropertyNodes, Object[]> {
            public void initialize(CrossParameterValidationAddingParameterBeanAndPropertyNodes constraintAnnotation) {
            }

            public boolean isValid(Object[] value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addParameterNode(0).addPropertyNode("myNode1").inIterable().atIndex(Integer.valueOf(23)).addBeanNode().addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface PropertyLevelValidationAddingBeanAndPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<PropertyLevelValidationAddingBeanAndPropertyNodes, Address> {
            public void initialize(PropertyLevelValidationAddingBeanAndPropertyNodes constraintAnnotation) {
            }

            public boolean isValid(Address value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode1").addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode2").inIterable().addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode3").inIterable().atIndex(Integer.valueOf(84)).addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode4").inIterable().atKey((Object)"AnotherKey").addBeanNode().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().atIndex(Integer.valueOf(42)).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addBeanNode().inIterable().atKey((Object)"Key").addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface ClassLevelValidationAddingPropertyNodes {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ClassLevelValidationAddingPropertyNodes, Foo> {
            public void initialize(ClassLevelValidationAddingPropertyNodes constraintAnnotation) {
            }

            public boolean isValid(Foo value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode1").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode2").addPropertyNode("myNode3").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode4").addPropertyNode("myNode5").inIterable().addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode6").addPropertyNode("myNode7").inIterable().atIndex(Integer.valueOf(42)).addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode8").addPropertyNode("myNode9").inIterable().atKey((Object)"Foo").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("myNode10").addPropertyNode("myNode11").inIterable().addPropertyNode("myNode12").addConstraintViolation();
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={Validator.class})
    public static @interface MyClassLevelValidation {
        public String message() default "failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<MyClassLevelValidation, MyObject> {
            public void initialize(MyClassLevelValidation constraintAnnotation) {
            }

            public boolean isValid(MyObject value, ConstraintValidatorContext context) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addNode("myNode1").addConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addNode("myNode2").addNode("myNode3").inIterable().atKey((Object)"key").addConstraintViolation();
                return false;
            }
        }
    }

    private static class Country {
        private Country() {
        }

        public String getName() {
            return null;
        }
    }

    private static class Address {
        private Address() {
        }

        public String getStreet() {
            return null;
        }

        public Country getCountry() {
            return null;
        }
    }

    private static class User {
        private User() {
        }

        @PropertyLevelValidationAddingBeanAndPropertyNodes
        public Address getAddress() {
            return null;
        }

        @CrossParameterValidationAddingParameterBeanAndPropertyNodes
        public void setAddresses(Map<String, Address> addresses) {
        }
    }

    private static class Bar {
        @FieldLevelValidationAddingParameterNode
        private String bar;

        private Bar() {
        }
    }

    private static class FooContainer {
        @Valid
        private final List<Foo> fooList = Arrays.asList(null, new Foo());
        @Valid
        private final Foo[] fooArray = new Foo[]{null, new Foo()};
        @Valid
        private final Set<Foo> fooSet = TestUtil.asSet(null, new Foo());
        @Valid
        private final Map<String, Foo> fooMap = new HashMap<String, Foo>();

        public FooContainer() {
            this.fooMap.put("MapKey", new Foo());
        }
    }

    @ClassLevelValidationAddingPropertyNodes
    private static class Foo {
        private Foo() {
        }
    }

    @MyClassLevelValidation
    private static class MyObject {
        @NotNull
        String field1;
        @NotNull
        String field2;

        private MyObject() {
        }
    }
}

