/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ElementKind;
import javax.validation.Path;

public class PathNodeKinds
implements Comparable<PathNodeKinds> {
    private final List<ElementKind> kinds;

    PathNodeKinds(ElementKind ... kinds) {
        this.kinds = Arrays.asList(kinds);
    }

    PathNodeKinds(Path path) {
        this.kinds = new ArrayList<ElementKind>();
        for (Path.Node node : path) {
            this.kinds.add(node.getKind());
        }
    }

    @Override
    public int compareTo(PathNodeKinds other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kinds == null ? 0 : ((Object)this.kinds).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathNodeKinds other = (PathNodeKinds)obj;
        return !(this.kinds == null ? other.kinds != null : !((Object)this.kinds).equals(other.kinds));
    }

    public String toString() {
        return "PathDescriptorKinds [kinds=" + this.kinds + "]";
    }
}

