/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class AssertConstraintsTests {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(AssertConstraintsTests.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="e")})
    public void testAssertTrueConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertTrueDummyEntity dummy = new AssertTrueDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertTrueDummyEntity.class, false, "primitiveBoolean");
        dummy.setPrimitiveBoolean(true);
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertTrueDummyEntity.class, Boolean.FALSE, "objectBoolean");
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="f")})
    public void testAssertFalseConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertFalseDummyEntity dummy = new AssertFalseDummyEntity();
        dummy.setPrimitiveBoolean(true);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertFalseDummyEntity.class, true, "primitiveBoolean");
        dummy.setPrimitiveBoolean(false);
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertFalseDummyEntity.class, Boolean.TRUE, "objectBoolean");
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    private static class AssertFalseDummyEntity {
        @AssertFalse
        private boolean primitiveBoolean;
        @AssertFalse
        private Boolean objectBoolean;

        private AssertFalseDummyEntity() {
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }

    private static class AssertTrueDummyEntity {
        @AssertTrue
        private boolean primitiveBoolean;
        @AssertTrue
        private Boolean objectBoolean;

        private AssertTrueDummyEntity() {
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }
}

