/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class SizeConstraintTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(SizeConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="k")})
    public void testSizeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        SizeDummyEntity dummy = new SizeDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        dummy.collection = new HashSet();
        dummy.collection.add("foo");
        dummy.collection.add("bar");
        dummy.string = "";
        dummy.map = new HashMap();
        dummy.map.put("key1", "value1");
        dummy.map.put("key2", "value2");
        SizeDummyEntity.access$402(dummy, new Integer[0]);
        SizeDummyEntity.access$502(dummy, new int[0]);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 5);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "collection", "map", "string", "integerArray", "intArray");
        dummy.collection.remove("bar");
        dummy.string = "a";
        SizeDummyEntity.access$402(dummy, new Integer[1]);
        SizeDummyEntity.access$502(dummy, new int[1]);
        dummy.map.remove("key1");
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    private static class SizeDummyEntity {
        @Size(min=1, max=1)
        private @Size(min=1, max=1) String string;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Collection<String> collection;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Map<String, String> map;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Integer[] integerArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) int[] intArray;

        private SizeDummyEntity() {
        }

        static /* synthetic */ Integer[] access$402(SizeDummyEntity x0, Integer[] x1) {
            x0.integerArray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$502(SizeDummyEntity x0, int[] x1) {
            x0.intArray = x1;
            return x1;
        }
    }
}

