/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.crossparameter;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.CrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.ExplicitGenericConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.GenericAndCrossParameterConstraintWithOneValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.GenericConstraint;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GenericAndCrossParameterConstraintTest
extends Arquillian {
    private Validator validator;
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GenericAndCrossParameterConstraintTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
        this.executableValidator = this.validator.forExecutables();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="b"), @SpecAssertion(section="3.4", id="e")})
    public void testAnnotatedElementIsTargetedByDefault() throws Exception {
        Calendar object = new Calendar();
        Method method = Calendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, GenericConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="3.4", id="e")
    public void testAnnotatedElementIsTargetedUsingSupportedValidationTarget() throws Exception {
        WebCalendar object = new WebCalendar();
        Method method = WebCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, ExplicitGenericConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="3.4", id="e")
    public void testParametersAreTargetedUsingSupportedValidationTarget() throws Exception {
        OnlineCalendar object = new OnlineCalendar();
        Method method = OnlineCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, CrossParameterConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)parameterValues);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="f"), @SpecAssertion(section="4.5.2.1", id="c"), @SpecAssertion(section="4.5.3", id="b")})
    public void testOneValidatorSupportsBothValidationTargets() throws Exception {
        MobileCalendar object = new MobileCalendar();
        Method method = MobileCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, GenericAndCrossParameterConstraintWithOneValidator.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
        method = MobileCalendar.class.getMethod("addEvent", Date.class, Date.class);
        violations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, GenericAndCrossParameterConstraintWithOneValidator.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)parameterValues);
    }

    private static class MobileCalendar {
        private MobileCalendar() {
        }

        @GenericAndCrossParameterConstraintWithOneValidator(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        public Object createEvent(Date start, Date end) {
            return null;
        }

        @GenericAndCrossParameterConstraintWithOneValidator(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object addEvent(Date start, Date end) {
            return null;
        }
    }

    private static class OnlineCalendar {
        private OnlineCalendar() {
        }

        @CrossParameterConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }

    private static class WebCalendar {
        private WebCalendar() {
        }

        @ExplicitGenericConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }

    private static class Calendar {
        private Calendar() {
        }

        @GenericConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }
}

