/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.ee.cdi;

import java.util.Set;
import javax.naming.InitialContext;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.integration.ee.cdi.GreetingConstraint;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintValidatorInjectionTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintValidatorInjectionTest.class)).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.2", id="c"), @SpecAssertion(section="10.3", id="a")})
    public void testJndiBoundValidatorFactoryIsCdiEnabled() throws Exception {
        ValidatorFactory validatorFactory = (ValidatorFactory)InitialContext.doLookup("java:comp/ValidatorFactory");
        Assert.assertNotNull((Object)validatorFactory, (String)"Default validator factory should be bound to JNDI tree.");
        Set violations = validatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "Hello, bar!", "Good morning, qux!");
    }

    private static class Foo {
        @GreetingConstraint(name="bar")
        public String bar;
        @GreetingConstraint(name="qux")
        public Integer qux;

        private Foo() {
        }
    }
}

