/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.messageinterpolation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExpressionLanguageMessageInterpolationTest
extends Arquillian {
    private Validator validator;
    private Locale originalLocale;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ExpressionLanguageMessageInterpolationTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
    }

    @BeforeMethod
    public void setDefaultLocaleToEnglish() {
        this.originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterMethod
    public void resetDefaultLocale() {
        Locale.setDefault(this.originalLocale);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1", id="e"), @SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="b")})
    public void testInterpolationWithElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "firstName", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "2");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="b")})
    public void testInterpolationWithSeveralElExpressions() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "lastName", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "2 some text 6");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="f")})
    public void testInterpolationWithUnknownElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "houseNo", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "${unknown}");
    }

    @Test
    @SpecAssertion(section="5.3.1.3", id="f")
    public void testInterpolationWithInvalidElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "addition", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "${1*}");
    }

    @Test
    @SpecAssertion(section="5.3.1.3", id="f")
    public void testInterpolationWithElExpressionThrowingAnException() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "continent", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "${validatedValue}");
    }

    @Test
    @SpecAssertion(section="5.3.1.3", id="a")
    public void testInterpolationWithIncompleteElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "zipCode", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "${incomplete");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="b")})
    public void testOnlyDollarSignIsSupportedForEnclosingElExpressions() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "middleName", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "#{1+1}");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="c")})
    public void testInterpolationUsingAnnotationAttributesInElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "street", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "must be longer than 30");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="c")})
    public void testInterpolationUsingGroupsAndPayloadInElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "country", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "groups: Default, payload: CustomPayload");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="d")})
    public void testInterpolationUsingValidatedValueInElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "city", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "Foo is not long enough");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="e")})
    public void testInterpolationUsingFormatterInElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "longitude", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "98.12 must be larger than 100");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="e")})
    public void testInterpolationUsingFormatterWithSeveralObjectsInElExpression() {
        Set violations = this.validator.validateProperty((Object)new TestBean(), "latitude", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "98.12 (that is, 98.1235) must be larger than 100");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3.1.3", id="a"), @SpecAssertion(section="5.3.1.3", id="e")})
    public void testInterpolationWithFormatterUsesDefaultLocaleInElExpression() {
        Locale.setDefault(Locale.GERMAN);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validateProperty((Object)new TestBean(), "longitude", new Class[0]);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "98,12 must be larger than 100");
    }

    @Documented
    @Constraint(validatedBy={Validator.class})
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidContinent {
        public String message() default "default message";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ValidContinent, Continent> {
            public boolean isValid(Continent continent, ConstraintValidatorContext constraintValidatorContext) {
                return false;
            }
        }
    }

    private static class Continent {
        private Continent() {
        }

        public String toString() {
            throw new RuntimeException("Invalid continent");
        }
    }

    private static class TestBean {
        @NotNull(message="${1+1}")
        private final @NotNull(message="${1+1}") String firstName;
        @NotNull(message="${1+1} some text ${2*3}")
        private final @NotNull(message="${1+1} some text ${2*3}") String lastName;
        @NotNull(message="#{1+1}")
        private final @NotNull(message="#{1+1}") String middleName;
        @Size(message="must be longer than ${(min * 2) + (max * 2)}", min=5, max=10)
        private final @Size(message="must be longer than ${(min * 2) + (max * 2)}", min=5, max=10) String street = "Foo";
        @Size(message="${validatedValue} is not long enough", min=5)
        private final @Size(message="${validatedValue} is not long enough", min=5) String city = "Foo";
        @NotNull(message="groups: ${groups[0].simpleName}, payload: ${payload[0].simpleName}", groups={Default.class}, payload={CustomPayload.class})
        private final @NotNull(message="groups: ${groups[0].simpleName}, payload: ${payload[0].simpleName}", groups={Default.class}, payload={CustomPayload.class}) String country;
        @Min(message="${formatter.format('%1$.2f', validatedValue)} must be larger than {value}", value=100L)
        private final @Min(message="${formatter.format('%1$.2f', validatedValue)} must be larger than {value}", value=100L) double longitude = 98.12345678;
        @Min(message="${formatter.format('%1$.2f (that is, %2$.4f)', validatedValue, validatedValue)} must be larger than {value}", value=100L)
        private final @Min(message="${formatter.format('%1$.2f (that is, %2$.4f)', validatedValue, validatedValue)} must be larger than {value}", value=100L) double latitude = 98.12345678;
        @NotNull(message="${unknown}")
        private final @NotNull(message="${unknown}") Integer houseNo = null;
        @NotNull(message="${incomplete")
        private final @NotNull(message="${incomplete") Integer zipCode = null;
        @NotNull(message="${1*}")
        private final @NotNull(message="${1*}") String addition;
        @ValidContinent(message="${validatedValue}")
        private final Continent continent = new Continent();

        private TestBean() {
            this.firstName = null;
            this.lastName = null;
            this.middleName = null;
            this.country = null;
            this.addition = null;
        }
    }

    private static interface CustomPayload
    extends Payload {
    }
}

