/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserInformation;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CustomConsistentUserValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Error;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.TestGroup;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.UserType;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class DuplicateConfigurationTest
extends Arquillian {
    public static final String packageName = "/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/";
    public static final String mappingFile1 = "user-constraints.xml";
    public static final String mappingFile2 = "user-constraints-MultipleBeanDefinitionTest.xml";
    public static final String mappingFile3 = "user-constraints-MultipleFieldDefinitionTest.xml";
    public static final String mappingFile4 = "user-constraints-MultipleGetterDefinitionTest.xml";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(DuplicateConfigurationTest.class)).withClasses(User.class, UserType.class, Error.class, CreditCard.class, Optional.class, ConsistentUserInformation.class, CustomConsistentUserValidator.class, ConsistentUserValidator.class, TestGroup.class)).withResource(mappingFile1)).withResource(mappingFile2)).withResource(mappingFile3)).withResource(mappingFile4)).build();
    }

    @Test
    @SpecAssertion(section="8.1", id="a")
    public void testXmlConfiguredConstraintExposesCorrespondingAnnotationViaMetadata() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/user-constraints.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Set constraintDescriptors = beanDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraintDescriptors.size(), (int)1, (String)"There should be one class level constraint defined in xml");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertTrue((boolean)(descriptor.getAnnotation() instanceof ConsistentUserInformation));
        constraintDescriptors = beanDescriptor.getConstraintsForProperty("lastname").getConstraintDescriptors();
        Assert.assertEquals((int)constraintDescriptors.size(), (int)1, (String)"There should be one constraint defined in xml for 'lastname'");
        descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertTrue((boolean)(descriptor.getAnnotation() instanceof Pattern));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1", id="b"), @SpecAssertion(section="8.1", id="e")})
    public void testBeanCannotBeDescribedMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/user-constraints.xml"));
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/user-constraints-MultipleBeanDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define the same bean multiple times.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1", id="c"), @SpecAssertion(section="8.1", id="e")})
    public void testFieldMappingCannotOccurMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/user-constraints-MultipleFieldDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define multiple field mappings per entity");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1", id="d"), @SpecAssertion(section="8.1", id="e")})
    public void testGetterMappingCannotOccurMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/user-constraints-MultipleGetterDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define multiple getter mappings per entity");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

