/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArtifactDumper {
    private static Logger logger = Logger.getLogger(ArtifactDumper.class.getName());
    private static File artifactDir;

    public static void main(String[] args) throws Exception {
        List<Class<?>> testClasses = ArtifactDumper.getClassesForPackage("org.hibernate.beanvalidation.tck");
        for (Class<?> clazz : testClasses) {
            ArtifactDumper.processClass(clazz);
        }
    }

    private static void processClass(Class<?> clazz) throws Exception {
        for (Method m : clazz.getMethods()) {
            if (!m.isAnnotationPresent(Deployment.class)) continue;
            Object o = clazz.newInstance();
            Archive archive = (Archive)m.invoke(o, new Object[0]);
            logger.fine(archive.toString(true));
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File(artifactDir, clazz.getName() + ".war"), true);
        }
    }

    private static List<Class<?>> getClassesForPackage(String packageName) throws ClassNotFoundException {
        ArrayList<File> directories = ArtifactDumper.findDirectoriesContainingClassesOfPackage(packageName);
        ArrayList classes = new ArrayList();
        for (File directory : directories) {
            if (!directory.exists()) continue;
            ArtifactDumper.addClassesForPackage(packageName, classes, directory);
        }
        return classes;
    }

    private static ArrayList<File> findDirectoriesContainingClassesOfPackage(String packageName) {
        ArrayList<File> directories = new ArrayList<File>();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = cld.getResources(path);
            while (resources.hasMoreElements()) {
                directories.add(new File(URLDecoder.decode(resources.nextElement().getPath(), "UTF-8")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return directories;
    }

    private static void addClassesForPackage(String packageName, ArrayList<Class<?>> classes, File directory) {
        assert (directory != null);
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getAbsolutePath().endsWith(".class")) {
                String className = file.getPath().substring(0, file.getPath().length() - 6);
                className = className.replace("/", ".");
                className = className.substring(className.indexOf(packageName));
                try {
                    Class<?> clazz = Class.forName(className);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            if (!file.isDirectory()) continue;
            ArtifactDumper.addClassesForPackage(packageName, classes, file);
        }
    }

    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                ArtifactDumper.delete(c);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete file: " + f);
        }
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentClassName = new RuntimeException().getStackTrace()[0].getClassName();
        int hopsToRoot = currentClassName.split("\\.").length;
        URL url = contextClassLoader.getResource(currentClassName.replace('.', '/') + ".class");
        if (url == null) {
            throw new RuntimeException("Unable to determine URL of " + currentClassName);
        }
        File targetDir = new File(url.getFile());
        for (int i = 0; i <= hopsToRoot; ++i) {
            targetDir = targetDir.getParentFile();
        }
        artifactDir = new File(targetDir, "artifacts");
        if (artifactDir.exists()) {
            for (File f : artifactDir.listFiles()) {
                ArtifactDumper.delete(f);
            }
        } else if (!artifactDir.mkdirs()) {
            throw new RuntimeException("Unable to create artifact dump directory: " + artifactDir.getPath());
        }
    }
}

