/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import java.util.EnumSet;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.executable.ExecutableType;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class BootstrapConfigurationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BootstrapConfigurationTest.class)).withValidationXml("validation-BootstrapConfigurationTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="f")
    public void testGetBootstrapConfiguration() {
        BootstrapConfiguration bootstrapConfiguration = TestUtil.getConfigurationUnderTest().getBootstrapConfiguration();
        Assert.assertNotNull((Object)bootstrapConfiguration);
        Assert.assertNotNull((Object)bootstrapConfiguration.getConstraintMappingResourcePaths());
        Assert.assertEquals((Set)bootstrapConfiguration.getConstraintMappingResourcePaths(), TestUtil.asSet("mapping1", "mapping2"));
        Assert.assertEquals((String)bootstrapConfiguration.getConstraintValidatorFactoryClassName(), (String)"com.acme.ConstraintValidatorFactory");
        Assert.assertEquals((String)bootstrapConfiguration.getDefaultProviderClassName(), (String)"com.acme.ValidationProvider");
        Assert.assertEquals((String)bootstrapConfiguration.getMessageInterpolatorClassName(), (String)"com.acme.MessageInterpolator");
        Assert.assertEquals((String)bootstrapConfiguration.getParameterNameProviderClassName(), (String)"com.acme.ParameterNameProvider");
        Assert.assertNotNull((Object)bootstrapConfiguration.getProperties());
        Assert.assertEquals((int)bootstrapConfiguration.getProperties().size(), (int)2);
        Assert.assertEquals((String)((String)bootstrapConfiguration.getProperties().get("com.acme.Foo")), (String)"Bar");
        Assert.assertEquals((String)((String)bootstrapConfiguration.getProperties().get("com.acme.Baz")), (String)"Qux");
        Assert.assertEquals((String)bootstrapConfiguration.getTraversableResolverClassName(), (String)"com.acme.TraversableResolver");
        Assert.assertNotNull((Object)bootstrapConfiguration.getDefaultValidatedExecutableTypes());
        Assert.assertEquals((Set)bootstrapConfiguration.getDefaultValidatedExecutableTypes(), EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS));
    }
}

