/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import java.util.Locale;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class CustomMessageInterpolatorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(CustomMessageInterpolatorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-message-customresolution", id="e")
    public void testCustomMessageInterpolatorViaConfiguration() {
        Configuration config = Validation.byDefaultProvider().configure();
        config = config.messageInterpolator((MessageInterpolator)new DummyMessageInterpolator());
        Validator validator = config.buildValidatorFactory().getValidator();
        this.assertCustomMessageInterpolatorUsed(validator);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="b"), @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="g"), @SpecAssertion(section="validationapi-message-customresolution", id="e")})
    public void testCustomMessageInterpolatorViaValidatorContext() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        DummyMessageInterpolator dummyMessageInterpolator = new DummyMessageInterpolator();
        Validator validator = factory.usingContext().messageInterpolator((MessageInterpolator)dummyMessageInterpolator).getValidator();
        this.assertCustomMessageInterpolatorUsed(validator);
        Assert.assertFalse((boolean)factory.getMessageInterpolator().equals(dummyMessageInterpolator), (String)"getMessageInterpolator() should return the default message interpolator.");
    }

    private void assertCustomMessageInterpolatorUsed(Validator validator) {
        Person person = new Person();
        person.setFirstName("John");
        person.setPersonalNumber(1234567890L);
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "my custom message");
    }

    public class Person {
        @NotNull
        private String firstName;
        @NotNull
        private String lastName;
        @Digits(integer=10, fraction=0)
        private @Digits(integer=10, fraction=0) long personalNumber;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public long getPersonalNumber() {
            return this.personalNumber;
        }

        public void setPersonalNumber(long personalNumber) {
            this.personalNumber = personalNumber;
        }
    }

    private static class DummyMessageInterpolator
    implements MessageInterpolator {
        private DummyMessageInterpolator() {
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            return "my custom message";
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            throw new UnsupportedOperationException("No specific locale is possible");
        }
    }
}

