/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap.customprovider;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidatorConfiguration;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class BootstrapCustomProviderDefinedInValidationXmlTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BootstrapCustomProviderDefinedInValidationXmlTest.class)).withClasses(TCKValidatorConfiguration.class, TCKValidationProvider.class)).withValidationXml("validation-BootstrapCustomProviderDefinedInValidationXmlTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping", id="a"), @SpecAssertion(section="validationapi-bootstrapping-configuration", id="l"), @SpecAssertion(section="validationapi-bootstrapping-validationprovider-provider", id="a")})
    public void testGetFactoryByProviderSpecifiedInValidationXml() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(TestUtil.getValidationProviderUnderTest());
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        ValidatorFactory factory = Validation.byDefaultProvider().providerResolver(resolver).configure().buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory), (String)"Since TCKValidationProvider is configured in validation.xml it should be the bootstrapped provider even though the provider under test is first in the list of providers in the resolver.");
    }
}

