/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.io.InputStream;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints.InvertedNotNullValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class BuiltinValidatorOverrideTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BuiltinValidatorOverrideTest.class)).withClass(InvertedNotNullValidator.class)).withResource("builtin-constraints-override.xml")).build();
    }

    @Test
    @SpecAssertion(section="builtinconstraints", id="b")
    public void testXmlConfiguredValidatorConfigurationHasPrecedence() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        InputStream in = TestUtil.getInputStreamForPath("org/hibernate/beanvalidation/tck/tests/constraints/builtinconstraints/builtin-constraints-override.xml");
        config.addMapping(in);
        Validator validator = config.buildValidatorFactory().getValidator();
        DummyEntity dummy = new DummyEntity();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        dummy.dummyProperty = "foobar";
        violations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
    }

    private static class DummyEntity {
        @NotNull
        private String dummyProperty;

        private DummyEntity() {
        }
    }
}

