/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.validation.ClockProvider;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Future;
import javax.validation.constraints.Past;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.FutureDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.FutureRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.PastDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.PastRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class FuturePastConstraintsTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(FuturePastConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="o")})
    public void testPastConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PastDummyEntity dummy = new PastDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        ZonedDateTime reference = ZonedDateTime.now(TZ_BERLIN);
        ZonedDateTime future = reference.plusYears(1L).plusMonths(1L).plusHours(1L);
        dummy = new PastDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
        ZonedDateTime past = reference.minusYears(1L).minusMonths(1L).minusHours(1L);
        dummy = new PastDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="o")})
    public void testPastConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 0, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastRelativePartialDummyEntity dummy = new PastRelativePartialDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        ZonedDateTime future = reference.plusMonths(1L).plusHours(1L);
        dummy = new PastRelativePartialDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "localTime", "monthDay", "offsetTime");
        ZonedDateTime past = reference.minusMonths(1L).minusHours(1L);
        dummy = new PastRelativePartialDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="p")})
    public void testFutureConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        FutureDummyEntity dummy = new FutureDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        ZonedDateTime reference = ZonedDateTime.now(TZ_BERLIN);
        ZonedDateTime past = reference.minusYears(1L).minusMonths(1L).minusHours(1L);
        dummy = new FutureDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
        ZonedDateTime future = reference.plusYears(1L).plusMonths(1L).plusHours(1L);
        dummy = new FutureDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="p")})
    public void testFutureConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 0, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureRelativePartialDummyEntity dummy = new FutureRelativePartialDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        ZonedDateTime past = reference.minusMonths(1L).minusHours(1L);
        dummy = new FutureRelativePartialDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "localTime", "monthDay", "offsetTime");
        ZonedDateTime future = reference.plusMonths(1L).plusHours(1L);
        dummy = new FutureRelativePartialDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="builtinconstraints", id="o")
    public void testPastOrPresentConstraint() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastDummyEntity pastDummy = new PastDummyEntity(reference);
        Set pastConstraintViolations = validator.validate((Object)pastDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastConstraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(pastConstraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
        PastOrPresentDummyEntity pastOrPresentDummy = new PastOrPresentDummyEntity();
        Set pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        pastOrPresentDummy = new PastOrPresentDummyEntity(reference);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 5, 5, 13, 14, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentDummyEntity(pastDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentDummyEntity(futureDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastConstraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(pastConstraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
    }

    @Test
    @SpecAssertion(section="builtinconstraints", id="o")
    public void testPastOrPresentConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastRelativePartialDummyEntity pastDummy = new PastRelativePartialDummyEntity(reference);
        Set pastConstraintViolations = validator.validate((Object)pastDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastConstraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(pastConstraintViolations, "localTime", "monthDay", "offsetTime");
        PastOrPresentRelativePartialDummyEntity pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity();
        Set pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(reference);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 5, 5, 13, 14, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(pastDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 0);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(futureDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(pastOrPresentConstraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(pastOrPresentConstraintViolations, "localTime", "monthDay", "offsetTime");
    }

    @Test
    @SpecAssertion(section="builtinconstraints", id="p")
    public void testFutureOrPresentConstraint() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureDummyEntity futureDummy = new FutureDummyEntity(reference);
        Set futureConstraintViolations = validator.validate((Object)futureDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureConstraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(futureConstraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
        FutureOrPresentDummyEntity futureOrPresentDummy = new FutureOrPresentDummyEntity();
        Set futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(reference);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(futureDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 4, 3, 12, 20, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(pastDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureConstraintViolations, 13);
        TestUtil.assertCorrectPropertyPaths(futureConstraintViolations, "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
    }

    @Test
    @SpecAssertion(section="builtinconstraints", id="p")
    public void testFutureOrPresentConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureRelativePartialDummyEntity futureDummy = new FutureRelativePartialDummyEntity(reference);
        Set futureConstraintViolations = validator.validate((Object)futureDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureConstraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(futureConstraintViolations, "localTime", "monthDay", "offsetTime");
        FutureOrPresentRelativePartialDummyEntity futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity();
        Set futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(reference);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(futureDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 0);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 4, 3, 12, 20, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(pastDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(futureOrPresentConstraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(futureOrPresentConstraintViolations, "localTime", "monthDay", "offsetTime");
    }

    private static class FutureOrPresentRelativePartialDummyEntity {
        @Future(orPresent=true)
        private @Future(orPresent=true) LocalTime localTime;
        @Future(orPresent=true)
        private @Future(orPresent=true) MonthDay monthDay;
        @Future(orPresent=true)
        private @Future(orPresent=true) OffsetTime offsetTime;

        public FutureOrPresentRelativePartialDummyEntity() {
        }

        public FutureOrPresentRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    private static class FutureOrPresentDummyEntity {
        @Future(orPresent=true)
        private @Future(orPresent=true) Calendar calendar;
        @Future(orPresent=true)
        private @Future(orPresent=true) Date date;
        @Future(orPresent=true)
        private @Future(orPresent=true) HijrahDate hijrahDate;
        @Future(orPresent=true)
        private @Future(orPresent=true) Instant instant;
        @Future(orPresent=true)
        private @Future(orPresent=true) JapaneseDate japaneseDate;
        @Future(orPresent=true)
        private @Future(orPresent=true) LocalDate localDate;
        @Future(orPresent=true)
        private @Future(orPresent=true) LocalDateTime localDateTime;
        @Future(orPresent=true)
        private @Future(orPresent=true) MinguoDate minguoDate;
        @Future(orPresent=true)
        private @Future(orPresent=true) OffsetDateTime offsetDateTime;
        @Future(orPresent=true)
        private @Future(orPresent=true) ThaiBuddhistDate thaiBuddhistDate;
        @Future(orPresent=true)
        private @Future(orPresent=true) Year year;
        @Future(orPresent=true)
        private @Future(orPresent=true) YearMonth yearMonth;
        @Future(orPresent=true)
        private @Future(orPresent=true) ZonedDateTime zonedDateTime;

        private FutureOrPresentDummyEntity() {
        }

        private FutureOrPresentDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }

    private static class PastOrPresentRelativePartialDummyEntity {
        @Past(orPresent=true)
        private @Past(orPresent=true) LocalTime localTime;
        @Past(orPresent=true)
        private @Past(orPresent=true) MonthDay monthDay;
        @Past(orPresent=true)
        private @Past(orPresent=true) OffsetTime offsetTime;

        public PastOrPresentRelativePartialDummyEntity() {
        }

        public PastOrPresentRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    private static class PastOrPresentDummyEntity {
        @Past(orPresent=true)
        private @Past(orPresent=true) Calendar calendar;
        @Past(orPresent=true)
        private @Past(orPresent=true) Date date;
        @Past(orPresent=true)
        private @Past(orPresent=true) HijrahDate hijrahDate;
        @Past(orPresent=true)
        private @Past(orPresent=true) Instant instant;
        @Past(orPresent=true)
        private @Past(orPresent=true) JapaneseDate japaneseDate;
        @Past(orPresent=true)
        private @Past(orPresent=true) LocalDate localDate;
        @Past(orPresent=true)
        private @Past(orPresent=true) LocalDateTime localDateTime;
        @Past(orPresent=true)
        private @Past(orPresent=true) MinguoDate minguoDate;
        @Past(orPresent=true)
        private @Past(orPresent=true) OffsetDateTime offsetDateTime;
        @Past(orPresent=true)
        private @Past(orPresent=true) ThaiBuddhistDate thaiBuddhistDate;
        @Past(orPresent=true)
        private @Past(orPresent=true) Year year;
        @Past(orPresent=true)
        private @Past(orPresent=true) YearMonth yearMonth;
        @Past(orPresent=true)
        private @Past(orPresent=true) ZonedDateTime zonedDateTime;

        public PastOrPresentDummyEntity() {
        }

        public PastOrPresentDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }
}

