/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class MinMaxConstraintsTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(MinMaxConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="g")})
    public void testMinConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        MinDummyEntity dummy = new MinDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.intObject = Integer.valueOf("100");
        dummy.longObject = Long.valueOf("0");
        dummy.byteObject = Byte.parseByte("-1");
        dummy.shortObject = Short.parseShort("3");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("102");
        dummy.shortObject = Short.parseShort("111");
        dummy.bigDecimal = BigDecimal.valueOf(101.1);
        dummy.bigInteger = BigInteger.valueOf(101L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="h")})
    public void testMaxConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        MaxDummyEntity dummy = new MaxDummyEntity();
        dummy.intPrimitive = 102;
        dummy.longPrimitive = 1234L;
        dummy.bytePrimitive = (byte)102;
        dummy.shortPrimitive = (short)102;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 100L;
        dummy.bytePrimitive = (byte)99;
        dummy.shortPrimitive = (short)42;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("100");
        dummy.byteObject = Byte.parseByte("100");
        dummy.shortObject = Short.parseShort("101");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    private static class MaxDummyEntity {
        @Max(value=101L)
        private @Max(value=101L) BigDecimal bigDecimal;
        @Max(value=101L)
        private @Max(value=101L) BigInteger bigInteger;
        @Max(value=101L)
        private @Max(value=101L) byte bytePrimitive;
        @Max(value=101L)
        private @Max(value=101L) short shortPrimitive;
        @Max(value=101L)
        private @Max(value=101L) int intPrimitive;
        @Max(value=101L)
        private @Max(value=101L) long longPrimitive;
        @Max(value=101L)
        private @Max(value=101L) Byte byteObject;
        @Max(value=101L)
        private @Max(value=101L) Short shortObject;
        @Max(value=101L)
        private @Max(value=101L) Integer intObject;
        @Max(value=101L)
        private @Max(value=101L) Long longObject;

        private MaxDummyEntity() {
        }
    }

    private static class MinDummyEntity {
        @Min(value=101L)
        private @Min(value=101L) BigDecimal bigDecimal;
        @Min(value=101L)
        private @Min(value=101L) BigInteger bigInteger;
        @Min(value=101L)
        private @Min(value=101L) byte bytePrimitive;
        @Min(value=101L)
        private @Min(value=101L) short shortPrimitive;
        @Min(value=101L)
        private @Min(value=101L) int intPrimitive;
        @Min(value=101L)
        private @Min(value=101L) long longPrimitive;
        @Min(value=101L)
        private @Min(value=101L) Byte byteObject;
        @Min(value=101L)
        private @Min(value=101L) Short shortObject;
        @Min(value=101L)
        private @Min(value=101L) Integer intObject;
        @Min(value=101L)
        private @Min(value=101L) Long longObject;

        private MinDummyEntity() {
        }
    }
}

