/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class PatternConstraintTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PatternConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="q")})
    public void testPatternConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PatternDummyEntity dummy = new PatternDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        dummy.pattern = "ab cd";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), PatternDummyEntity.class, "ab cd", "pattern");
        dummy.pattern = "wc 00";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    private static class PatternDummyEntity {
        @Pattern(regexp="[a-z][a-z] \\d\\d")
        private @Pattern(regexp="[a-z][a-z] \\d\\d") String pattern;

        private PatternDummyEntity() {
        }
    }
}

