/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ComposedConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ComposedGenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddress;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddressListContainer;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddressMixDirectAnnotationAndListContainer;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcode;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcodeWithInvalidOverride;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Friend;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.GermanAddress;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ParametersNotEmpty;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Severity;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Shoe;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintCompositionTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClassPackage(ConstraintCompositionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="p")})
    public void testComposedConstraints() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "may not be null");
        TestUtil.assertConstraintViolation(constraintViolation, FrenchAddress.class, null, "zipCode");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="p")})
    public void testComposedConstraintsAreRecursive() {
        GermanAddress address = new GermanAddress();
        address.setAddressline1("Rathausstrasse 5");
        address.setAddressline2("3ter Stock");
        address.setCity("Karlsruhe");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), GermanAddress.class, null, "zipCode");
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="b")
    public void testValidationOfMainAnnotationIsAlsoApplied() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        address.setZipCode("00000");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, FrenchZipcode.class);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "00000 is a reserved code");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="c"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="n"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="q"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="r"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="u")})
    public void testEachFailingConstraintCreatesConstraintViolation() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Pattern.class, Pattern.class, Size.class);
        for (ConstraintViolation violation : constraintViolations) {
            TestUtil.assertConstraintViolation(violation, FrenchAddress.class, "abc", "zipCode");
        }
        address.setZipCode("123");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Pattern.class, Size.class);
        for (ConstraintViolation violation : constraintViolations) {
            TestUtil.assertConstraintViolation(violation, FrenchAddress.class, "123", "zipCode");
        }
        address.setZipCode("33023");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="s")
    public void testConstraintIndexWithListContainer() {
        FrenchAddressListContainer address = this.getFrenchAddressListContainerWithoutZipCode();
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Pattern.class, Pattern.class, Size.class);
        for (ConstraintViolation violation : constraintViolations) {
            TestUtil.assertConstraintViolation(violation, FrenchAddressListContainer.class, "abc", "zipCode");
        }
        address.setZipCode("33023");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="t")
    public void testConstraintIndexWithMixDirectAnnotationAndListContainer() {
        FrenchAddressMixDirectAnnotationAndListContainer address = this.getFrenchAddressMixDirectAnnotationAndListContainerWithoutZipCode();
        address.setZipCode("abc");
        this.getValidator().validate((Object)address, new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="d"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="e")})
    public void testGroupsDefinedOnMainAnnotationAreInherited() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        NotNull notNull = (NotNull)constraintViolation.getConstraintDescriptor().getAnnotation();
        List<Class> groups = Arrays.asList(notNull.groups());
        Assert.assertTrue((groups.size() == 2 ? 1 : 0) != 0, (String)"There should be two groups");
        Assert.assertTrue((boolean)groups.contains(Default.class), (String)"The default group should be in the list.");
        Assert.assertTrue((boolean)groups.contains(FrenchAddress.FullAddressCheck.class), (String)"The FrenchAddress.FullAddressCheck group should be inherited.");
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testOnlySingleConstraintViolation() {
        GermanAddress address = new GermanAddress();
        address.setAddressline1("Rathausstrasse 5");
        address.setAddressline2("3ter Stock");
        address.setCity("Karlsruhe");
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), GermanAddress.class, "abc", "zipCode");
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="m")
    public void testAttributesDefinedOnComposingConstraints() {
        BeanDescriptor descriptor = this.getValidator().getConstraintsForClass(FrenchAddress.class);
        Set constraintDescriptors = descriptor.getConstraintsForProperty("zipCode").getConstraintDescriptors();
        boolean findPattern = this.checkForAppropriateAnnotation(constraintDescriptors);
        Assert.assertTrue((boolean)findPattern, (String)"Could not find @Pattern in composing constraints");
    }

    private boolean checkForAppropriateAnnotation(Set<ConstraintDescriptor<?>> constraintDescriptors) {
        boolean findPattern = false;
        for (ConstraintDescriptor<?> constraintDescriptor : constraintDescriptors) {
            Annotation ann = constraintDescriptor.getAnnotation();
            if (Pattern.class.getName().equals(ann.annotationType().getName())) {
                String regexp = ((Pattern)ann).regexp();
                if (regexp.equals("bar")) {
                    Assert.fail((String)"The regular expression attributes are defined in the composing constraint.");
                }
                findPattern = true;
            }
            findPattern |= this.checkForAppropriateAnnotation(constraintDescriptor.getComposingConstraints());
        }
        return findPattern;
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="o"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="v")})
    public void testOverriddenAttributesMustMatchInType() {
        this.getValidator().validate((Object)new DummyEntityWithZipCode("foobar"), new Class[0]);
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="j")
    public void testAllComposingConstraintsMustBeApplicableToAnnotatedType() {
        this.getValidator().validate((Object)new Shoe(41), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="f"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="g")})
    public void testPayloadPropagationInComposedConstraints() {
        Friend john = new Friend("John", "Doe");
        Set constraintViolations = this.getValidator().validate((Object)john, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Set payloads = constraintViolation.getConstraintDescriptor().getPayload();
        Assert.assertTrue((payloads.size() == 1 ? 1 : 0) != 0, (String)"There should be one payload in the set");
        Class payload = (Class)payloads.iterator().next();
        Assert.assertTrue((boolean)payload.getName().equals(Severity.Warn.class.getName()), (String)"Unexpected payload");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="h"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="i")})
    public void testConstraintTargetPropagationInComposedConstraints() throws Exception {
        DummyEntityWithGenericAndCrossParameterConstraint object = new DummyEntityWithGenericAndCrossParameterConstraint();
        Method method = DummyEntityWithGenericAndCrossParameterConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{0};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, GenericAndCrossParameterConstraint.class);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getConstraintDescriptor().getValidationAppliesTo(), (Object)ConstraintTarget.PARAMETERS);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="k"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="v")})
    public void testMixedConstraintTargetsInComposedAndComposingConstraintsCauseException() throws Exception {
        DummyEntityWithIllegallyComposedConstraint object = new DummyEntityWithIllegallyComposedConstraint();
        Method method = DummyEntityWithIllegallyComposedConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="k"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="v")})
    public void testMixedConstraintTargetsInComposingConstraintsCauseException() throws Exception {
        DummyEntityWithAnotherIllegallyComposedConstraint object = new DummyEntityWithAnotherIllegallyComposedConstraint();
        Method method = DummyEntityWithAnotherIllegallyComposedConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    private FrenchAddress getFrenchAddressWithoutZipCode() {
        FrenchAddress address = new FrenchAddress();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private FrenchAddressListContainer getFrenchAddressListContainerWithoutZipCode() {
        FrenchAddressListContainer address = new FrenchAddressListContainer();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private FrenchAddressMixDirectAnnotationAndListContainer getFrenchAddressMixDirectAnnotationAndListContainerWithoutZipCode() {
        FrenchAddressMixDirectAnnotationAndListContainer address = new FrenchAddressMixDirectAnnotationAndListContainer();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private static class DummyEntityWithAnotherIllegallyComposedConstraint {
        private DummyEntityWithAnotherIllegallyComposedConstraint() {
        }

        @ComposedConstraint
        public void doSomething(int i) {
        }
    }

    private static class DummyEntityWithIllegallyComposedConstraint {
        private DummyEntityWithIllegallyComposedConstraint() {
        }

        @ParametersNotEmpty
        public Object doSomething(int i) {
            return null;
        }
    }

    private static class DummyEntityWithGenericAndCrossParameterConstraint {
        private DummyEntityWithGenericAndCrossParameterConstraint() {
        }

        @ComposedGenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object doSomething(int i) {
            return null;
        }
    }

    private static class DummyEntityWithZipCode {
        @FrenchZipcodeWithInvalidOverride
        String zip;

        DummyEntityWithZipCode(String zip) {
            this.zip = zip;
        }
    }
}

