/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.GroupDefinitionException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Animal;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Auditable;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Author;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Book;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.CreditCard;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.CyclicGroupSequence;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.CyclicGroupSequence1;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.CyclicGroupSequence2;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.First;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Last;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Order;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Second;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GroupTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(GroupTest.class)).withClasses(User.class, CreditCard.class, Author.class, Book.class, Animal.class, First.class, Second.class, Last.class, Order.class, Auditable.class, CyclicGroupSequence.class, CyclicGroupSequence1.class, CyclicGroupSequence2.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="a")
    public void testConstraintWithNoExplicitlySpecifiedGroupBelongsToDefault() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        PropertyDescriptor propDesc = beanDescriptor.getConstraintsForProperty("firstname");
        Assert.assertTrue((propDesc.getConstraintDescriptors().size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor descriptor = (ConstraintDescriptor)propDesc.getConstraintDescriptors().iterator().next();
        Assert.assertTrue((descriptor.getGroups().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(descriptor.getGroups().iterator().next(), Default.class, (String)"Constraint should implicitly belong to the Default group.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="d")})
    public void testValidateAgainstDifferentGroups() {
        User user = new User();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        Assert.assertEquals((int)constraintViolations.size(), (int)2, (String)"There should be two violations against the implicit default group");
        constraintViolations = validator.validate((Object)user, new Class[]{Default.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)2, (String)"There should be two violations against the explicit default group");
        constraintViolations = validator.validate((Object)user, new Class[]{User.Billable.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"There should be one violation against Billable");
        constraintViolations = validator.validate((Object)user, new Class[]{Default.class, User.Billable.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"There should be 3 violation against Default and  Billable");
        constraintViolations = validator.validate((Object)user, new Class[]{User.BuyInOneClick.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"Three violations expected since BuyInOneClick extends Default and Billable");
        constraintViolations = validator.validate((Object)user, new Class[]{User.BuyInOneClick.class, User.Billable.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"BuyInOneClick already contains all other groups. Adding Billable does not change the number of violations");
        constraintViolations = validator.validate((Object)user, new Class[]{User.BuyInOneClick.class, Default.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"BuyInOneClick already contains all other groups. Adding Default does not change the number of violations");
        constraintViolations = validator.validate((Object)user, new Class[]{User.BuyInOneClick.class, Default.class, User.Billable.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"BuyInOneClick already contains all other groups. Adding Billable and Default does not change the number of violations");
        constraintViolations = validator.validate((Object)user, new Class[]{User.Billable.class, User.Billable.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"Adding the same group twice is still only leads to a single violation");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="c")
    public void testConstraintCanBelongToMoreThanOneGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        PropertyDescriptor propDesc = beanDescriptor.getConstraintsForProperty("defaultCreditCard");
        Assert.assertTrue((propDesc.getConstraintDescriptors().size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor descriptor = (ConstraintDescriptor)propDesc.getConstraintDescriptors().iterator().next();
        Assert.assertTrue((descriptor.getGroups().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="d")
    public void testGroups() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Author author = new Author();
        author.setLastName("");
        author.setFirstName("");
        Book book = new Book();
        book.setTitle("");
        book.setAuthor(author);
        Set constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)3, (String)"Wrong number of constraints");
        author.setFirstName("Gavin");
        author.setLastName("King");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"Wrong number of constraints");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)book, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)book.getTitle(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "title");
        book.setTitle("Hibernate Persistence with JPA");
        book.setSubtitle("Revised Edition of Hibernate in Action");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "The book's subtitle can only have 30 characters");
        constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)book, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)book.getSubtitle(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "subtitle");
        book.setSubtitle("Revised Edition");
        author.setCompany("JBoss a division of RedHat");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "The company name can only have 20 characters");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)book, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)author.getCompany(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "author.company");
        author.setCompany("JBoss");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)0, (String)"Wrong number of constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="d")})
    public void testGroupSequence() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Author author = new Author();
        author.setLastName("");
        author.setFirstName("");
        Book book = new Book();
        book.setAuthor(author);
        Set constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)2, (String)"Wrong number of constraints");
        author.setFirstName("Gavin");
        author.setLastName("King");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "The book title cannot be null");
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)book, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)book.getTitle(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "title");
        book.setTitle("Hibernate Persistence with JPA");
        book.setSubtitle("Revised Edition of Hibernate in Action");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"Wrong number of constraints");
        book.setSubtitle("Revised Edition");
        author.setCompany("JBoss a division of RedHat");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"Wrong number of constraints");
        author.setCompany("JBoss");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)0, (String)"Wrong number of constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testValidationFailureInMultipleGroups() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Animal elephant = new Animal();
        elephant.setName("");
        elephant.setDomain(Animal.Domain.EUKARYOTA);
        Set constraintViolations = validator.validate((Object)elephant, new Class[]{First.class, Second.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"The should be only one invalid constraint even though the constraint belongs to both groups");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence", id="d")
    public void testGroupSequenceFollowedByGroup() {
        User user = new User();
        user.setFirstname("Foo");
        user.setLastname("Bar");
        user.setPhoneNumber("+46 123-456");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)user, new Class[]{User.BuyInOneClick.class, User.Optional.class});
        Assert.assertEquals((int)constraintViolations.size(), (int)2, (String)"There should be two violations against the implicit default group");
        for (ConstraintViolation constraintViolation : constraintViolations) {
            if (TestUtil.assertEqualPaths(constraintViolation.getPropertyPath(), TestUtil.PathImpl.createPathFromString("defaultCreditCard"))) {
                TestUtil.assertConstraintViolation(constraintViolation, User.class, null, "defaultCreditCard");
                continue;
            }
            if (TestUtil.assertEqualPaths(constraintViolation.getPropertyPath(), TestUtil.PathImpl.createPathFromString("phoneNumber"))) {
                TestUtil.assertConstraintViolation(constraintViolation, User.class, "+46 123-456", "phoneNumber");
                continue;
            }
            Assert.fail((String)"Unexpected violation");
        }
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-implicitgrouping", id="a")
    public void testImplicitGrouping() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        Order order = new Order();
        Set violations = validator.validate((Object)order, new Class[0]);
        Assert.assertTrue((violations.size() == 5 ? 1 : 0) != 0, (String)"All 5 NotNull constraints should fail.");
        violations = validator.validate((Object)order, new Class[]{Auditable.class});
        Assert.assertTrue((violations.size() == 4 ? 1 : 0) != 0, (String)"All 4 NotNull constraints on Auditable should fail.");
    }

    @Test(expectedExceptions={GroupDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-formaldefinition", id="j"), @SpecAssertion(section="exception-groupdefinition", id="a")})
    public void testCyclicGroupSequence() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Order(), new Class[]{CyclicGroupSequence.class});
    }
}

