/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import javax.validation.ConstraintDeclarationException;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.User;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationConstructorParameter;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationOnConstructorReturnValue;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationOnField;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationOnMethodParameter;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationOnMethodReturnValue;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionButWithoutValidAnnotationOnProperty;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithGroupConversionWithSequenceAsFrom;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.model.UserWithSeveralGroupConversionsForSameFrom;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.UserReadService;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnParameter;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnReturnValue;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.ImplementationOfParallelInterfacesWithGroupConversionOnParameter;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.ImplementationOfParallelInterfacesWithGroupConversionOnReturnValue;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.InterfaceImplementationWithGroupConversionOnParameter;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupconversion.service.impl.SubClassWithGroupConversionOnParameter;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class InvalidGroupDefinitionsTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClassPackage(InvalidGroupDefinitionsTest.class)).withPackage(User.class.getPackage())).withPackage(SubClassWithGroupConversionOnParameter.class.getPackage())).withPackage(UserReadService.class.getPackage())).build();
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnField() {
        this.getValidator().validate((Object)new UserWithGroupConversionButWithoutValidAnnotationOnField(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnProperty() {
        this.getValidator().validate((Object)new UserWithGroupConversionButWithoutValidAnnotationOnProperty(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnMethodReturnValue() throws Exception {
        UserWithGroupConversionButWithoutValidAnnotationOnMethodReturnValue object = new UserWithGroupConversionButWithoutValidAnnotationOnMethodReturnValue();
        Method method = UserWithGroupConversionButWithoutValidAnnotationOnMethodReturnValue.class.getMethod("retrieveAddresses", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnMethodParameter() throws Exception {
        UserWithGroupConversionButWithoutValidAnnotationOnMethodParameter object = new UserWithGroupConversionButWithoutValidAnnotationOnMethodParameter();
        Method method = UserWithGroupConversionButWithoutValidAnnotationOnMethodParameter.class.getMethod("setAddresses", List.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnConstructorReturnValue() throws Exception {
        UserWithGroupConversionButWithoutValidAnnotationOnConstructorReturnValue object = new UserWithGroupConversionButWithoutValidAnnotationOnConstructorReturnValue();
        Constructor constructor = UserWithGroupConversionButWithoutValidAnnotationOnConstructorReturnValue.class.getConstructor(new Class[0]);
        this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)object, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="a")
    public void testGroupConversionWithoutValidAnnotationOnConstructorParameter() throws Exception {
        Constructor constructor = UserWithGroupConversionButWithoutValidAnnotationConstructorParameter.class.getConstructor(List.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateConstructorParameters(constructor, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="e")
    public void testSeveralGroupConversionsWithSameFrom() {
        this.getValidator().validate((Object)new UserWithSeveralGroupConversionsForSameFrom(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="f")
    public void testGroupConversionWithSequenceAsFrom() {
        this.getValidator().validate((Object)new UserWithGroupConversionWithSequenceAsFrom(), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnParameterInSubClass() throws Exception {
        SubClassWithGroupConversionOnParameter object = new SubClassWithGroupConversionOnParameter();
        Method method = SubClassWithGroupConversionOnParameter.class.getMethod("addUser", User.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnParameterInImplementingClass() throws Exception {
        InterfaceImplementationWithGroupConversionOnParameter object = new InterfaceImplementationWithGroupConversionOnParameter();
        Method method = InterfaceImplementationWithGroupConversionOnParameter.class.getMethod("addUser", User.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnParameterInParallelInterfaces() throws Exception {
        ImplementationOfParallelInterfacesWithGroupConversionOnParameter object = new ImplementationOfParallelInterfacesWithGroupConversionOnParameter();
        Method method = ImplementationOfParallelInterfacesWithGroupConversionOnParameter.class.getMethod("addUser", User.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnReturnValueInParallelInterfaces() throws Exception {
        ImplementationOfParallelInterfacesWithGroupConversionOnReturnValue object = new ImplementationOfParallelInterfacesWithGroupConversionOnReturnValue();
        Method method = ImplementationOfParallelInterfacesWithGroupConversionOnReturnValue.class.getMethod("getUser", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnParameterInSuperClassAndImplementedInterface() throws Exception {
        ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnParameter object = new ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnParameter();
        Method method = ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnParameter.class.getMethod("addUser", User.class);
        Object[] parameters = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="j")})
    public void testGroupConversionGivenOnReturnValueInSuperClassAndImplementedInterface() throws Exception {
        ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnReturnValue object = new ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnReturnValue();
        Method method = ImplementationOfInterfaceAndSuperClassBothWithGroupConversionOnReturnValue.class.getMethod("getUser", new Class[0]);
        Object returnValue = null;
        this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
    }
}

