/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.constraint.ValidBusinessCalendarEvent;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.constraint.ValidCalendarEvent;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.constraint.ValidCalendarServiceSubClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.model.CalendarEvent;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.service.CalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.service.impl.BusinessCalendarServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.service.impl.CalendarServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.service.impl.CalendarServiceSubClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.validdeclarations.service.impl.ImplementationOfParallelInterfacesMarkingReturnValueAsCascaded;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidMethodConstraintDeclarationTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClassPackage(ValidMethodConstraintDeclarationTest.class)).withPackage(ValidCalendarEvent.class.getPackage())).withPackage(CalendarEvent.class.getPackage())).withPackage(CalendarServiceImplementation.class.getPackage())).withPackage(CalendarService.class.getPackage())).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueConstraintAddedInInterfaceImplementation() throws Exception {
        CalendarServiceImplementation object = new CalendarServiceImplementation();
        Method method = this.getCreateEventMethod(object);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueConstraintAddedInSubClass() throws Exception {
        CalendarServiceSubClass object = new CalendarServiceSubClass();
        Method method = this.getCreateEventMethod(object);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueMarkedAsCascadedInInterfaceImplementation() throws Exception {
        CalendarServiceImplementation object = new CalendarServiceImplementation();
        Method method = this.getCreateEventWithDurationMethod(object);
        CalendarEvent returnValue = new CalendarEvent();
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "createEvent", "<return value>", "name");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueConstraintFromInterfaceAndImplementationAddUp() throws Exception {
        CalendarServiceImplementation object = new CalendarServiceImplementation();
        Method method = this.getCreateEventWithParticipantsMethod(object);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, ValidCalendarEvent.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueConstraintFromInterfacesAndImplementationAddUp() throws Exception {
        BusinessCalendarServiceImplementation object = new BusinessCalendarServiceImplementation();
        Method method = this.getCreateEventWithParticipantsMethod(object);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, ValidCalendarEvent.class, ValidBusinessCalendarEvent.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="c")
    public void testReturnValueMarkedAsCascadedInSubClass() throws Exception {
        CalendarServiceSubClass object = new CalendarServiceSubClass();
        Method method = this.getCreateEventWithDurationMethod(object);
        CalendarEvent returnValue = new CalendarEvent();
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "createEvent", "<return value>", "name");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="f")
    public void testParameterConstraintAddedToConstructorInSubClass() throws Exception {
        Constructor constructor = CalendarServiceSubClass.class.getConstructor(Integer.TYPE);
        Object[] parameterValues = new Object[]{4};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Min.class);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="f")
    public void testParameterConstraintMarkedAsCascadedAtConstructorInSubClass() throws Exception {
        Constructor constructor = CalendarServiceSubClass.class.getConstructor(CalendarEvent.class);
        Object[] parameterValues = new Object[]{new CalendarEvent()};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "CalendarServiceSubClass", "defaultEvent", "name");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="f")
    public void testReturnValueConstraintAddedToConstructorInSubClass() throws Exception {
        Constructor constructor = CalendarServiceSubClass.class.getConstructor(String.class);
        CalendarServiceSubClass returnValue = new CalendarServiceSubClass();
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidCalendarServiceSubClass.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "CalendarServiceSubClass", "<return value>");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="f")
    public void testReturnValueMarkedAsCascadedAtConstructorInSuperAndSubClass() throws Exception {
        Constructor constructor = CalendarServiceSubClass.class.getConstructor(Long.TYPE);
        CalendarServiceSubClass returnValue = new CalendarServiceSubClass();
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Min.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "CalendarServiceSubClass", "<return value>", "mode");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="d")
    public void testReturnValueMarkedAsCascadedInParallelInterfaces() throws Exception {
        ImplementationOfParallelInterfacesMarkingReturnValueAsCascaded object = new ImplementationOfParallelInterfacesMarkingReturnValueAsCascaded();
        Method method = this.getCreateEventMethod(object);
        CalendarEvent returnValue = new CalendarEvent();
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertNodeNames(((ConstraintViolation)violations.iterator().next()).getPropertyPath(), "createEvent", "<return value>", "name");
    }

    private Method getCreateEventMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("createEvent", Date.class, Date.class);
    }

    private Method getCreateEventWithDurationMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("createEvent", Date.class, Date.class, Integer.TYPE);
    }

    private Method getCreateEventWithParticipantsMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("createEvent", Date.class, Date.class, List.class);
    }
}

