/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.lang.annotation.ElementType;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import org.hibernate.beanvalidation.tck.tests.metadata.SubClass;
import org.hibernate.beanvalidation.tck.tests.metadata.SuperClass;
import org.hibernate.beanvalidation.tck.tests.metadata.SuperConstraint;
import org.hibernate.beanvalidation.tck.tests.metadata.SuperConstraintValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ElementDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ElementDescriptorTest.class)).withClasses(SuperClass.class, SubClass.class, SuperConstraint.class, SuperConstraintValidator.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClass() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SuperClass.class);
        Assert.assertEquals((Object)beanDescriptor.getElementClass(), SuperClass.class, (String)"Wrong element class");
        PropertyDescriptor elementDescriptor = beanDescriptor.getConstraintsForProperty("myField");
        Assert.assertEquals((Object)elementDescriptor.getElementClass(), String.class, (String)"Wrong element class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="b")
    public void testGetConstraintDescriptors() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(SubClass.class, "myField");
        Assert.assertEquals((int)descriptor.getConstraintDescriptors().size(), (int)2, (String)"There should be two constraints on myField");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="c")
    public void testHasConstraints() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(SubClass.class, "myField");
        AssertJUnit.assertTrue((boolean)descriptor.hasConstraints());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="e")})
    public void testUnorderedAndMatchingGroups() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{Default.class, SuperClass.BasicGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{SuperClass.UnusedGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="e")})
    public void testUnorderedAndMatchingGroupsWithInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{SuperClass.InheritedGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="e")})
    public void testUnorderedAndMatchingGroupsWithDefaultGroupOverriding() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{Default.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="f")})
    public void testDeclaredOn() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.TYPE}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.METHOD}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.FIELD}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="g")})
    public void testLookingAt() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }
}

