/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.tests.metadata.Severity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class PropertyDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PropertyDescriptorTest.class)).withClasses(Account.class, Order.class, Person.class, Customer.class, Severity.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClass() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertEquals((Object)descriptor.getElementClass(), Integer.class, (String)"Wrong element class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsNotCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-propertydescriptor", id="a")
    public void testPropertyName() {
        String propertyName = "orderList";
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, propertyName);
        Assert.assertEquals((String)descriptor.getPropertyName(), (String)propertyName, (String)"Wrong property name");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForField() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(Customer.StrictCustomerChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForProperty() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "account");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(Customer.StrictCustomerChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySet() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "firstName");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }
}

