/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ReturnValueDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ReturnValueDescriptorTest.class)).withClasses(Account.class, Customer.class, CustomerService.class, Executables.class, Person.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForMethod() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedMethod().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), Integer.TYPE);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), Void.TYPE);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForConstructor() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedConstructor().getReturnValueDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), CustomerService.class);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForMethodReturnValue() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedMethod().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
        descriptor = Executables.cascadedReturnValueMethod().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForConstructorReturnValue() {
        ReturnValueDescriptor descriptor = Executables.returnValueConstrainedConstructor().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
        descriptor = Executables.cascadedReturnValueConstructor().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertFalse((boolean)descriptor.isCascaded());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForConstructorReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.constructorWithGroupConversionOnReturnValue().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForVoidMethod() {
        ReturnValueDescriptor descriptor = Executables.parameterConstrainedMethod().getReturnValueDescriptor();
        Assert.assertTrue((boolean)descriptor.getGroupConversions().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForMethodReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.methodWithGroupConversionOnReturnValue().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForConstructorReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.cascadedReturnValueMethod().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForMethodReturnValue() {
        ReturnValueDescriptor returnValueDescriptor = Executables.cascadedReturnValueConstructor().getReturnValueDescriptor();
        Set groupConversions = returnValueDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }
}

