/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidLineItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidWarehouseItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.LineItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.WarehouseItem;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableValidationIgnoresValidatedExecutableAnnotationSettingsTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClass(ExecutableValidationIgnoresValidatedExecutableAnnotationSettingsTest.class)).withClass(LineItem.class)).withClass(WarehouseItem.class)).withClass(ValidLineItem.class)).withClass(ValidWarehouseItem.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        LineItem object = new LineItem(null);
        String methodName = "setName";
        Method method = LineItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        Constructor constructor = LineItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(LineItem.class.getSimpleName(), "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        LineItem object = new LineItem(null);
        String methodName = "setName";
        Method method = LineItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        Constructor constructor = LineItem.class.getConstructor(String.class);
        LineItem createdObject = new LineItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidLineItem.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(LineItem.class.getSimpleName(), "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        WarehouseItem object = new WarehouseItem(null);
        String methodName = "setName";
        Method method = WarehouseItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        Constructor constructor = WarehouseItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(WarehouseItem.class.getSimpleName(), "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        WarehouseItem object = new WarehouseItem(null);
        String methodName = "setName";
        Method method = WarehouseItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        Constructor constructor = WarehouseItem.class.getConstructor(String.class);
        WarehouseItem createdObject = new WarehouseItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidWarehouseItem.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(WarehouseItem.class.getSimpleName(), "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }
}

