/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidStockItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.StockItem;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClass(ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.class)).withClass(StockItem.class)).withClass(ValidStockItem.class)).withValidationXml("validation-ExecutableValidationIgnoresValidatedExecutableXmlSettingsTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(StockItem.class.getSimpleName(), "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        StockItem object = new StockItem(null);
        String methodName = "setName";
        Method method = StockItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEInXml() throws Exception {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        Constructor constructor = StockItem.class.getConstructor(String.class);
        StockItem createdObject = new StockItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidStockItem.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(StockItem.class.getSimpleName(), "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }
}

