/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.OrderLine;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidateParametersTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClass(ValidateParametersTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Item.class)).withClass(OrderLine.class)).withClass(User.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="a"), @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolation() throws Exception {
        String methodName = "setFirstName";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class);
        String arg0 = "B";
        Object[] parameterValues = new Object[]{arg0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "firstName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)object);
        Assert.assertEquals((Object)violation.getRootBeanClass(), User.class);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)object);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)arg0);
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="j")})
    public void testOneViolationFromCrossParameterConstraint() throws Exception {
        String methodName = "setAddress";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)object);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)parameterValues);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoViolations() throws Exception {
        String methodName = "setNames";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{null, "S"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "firstName"), TestUtil.names(methodName, "lastName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoViolationsOnSameParameter() throws Exception {
        String methodName = "setFirstNameStrict";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{"S", 0};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Pattern.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "firstName"), TestUtil.names(methodName, "firstName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testTwoConstraintsOfSameType() throws Exception {
        String methodName = "setLastNameStrict";
        User object = new User();
        Method method = User.class.getMethod(methodName, CharSequence.class);
        Object[] parameterValues = new Object[]{"S"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "lastName"), TestUtil.names(methodName, "lastName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testCrossParameterConstraintGivenSeveralTimes() throws Exception {
        String methodName = "setAddress";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class, String.class);
        Object[] parameterValues = new Object[]{null, null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "<cross-parameter>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testNoViolations() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{"Bob", "Smith"};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testValidationWithGroup() throws Exception {
        String methodName = "setLastName";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, Long.TYPE);
        Object[] parameterValues = new Object[]{"S", 0L};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "lastName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testCrossParameterConstraintValidationWithGroup() throws Exception {
        String methodName = "setAddressExtended";
        User object = new User();
        Method method = User.class.getMethod(methodName, CharSequence.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="b")
    public void testValidationWithSeveralGroups() throws Exception {
        String methodName = "setAllData";
        User object = new User();
        Method method = User.class.getMethod(methodName, String.class, String.class, Date.class);
        Object[] parameterValues = new Object[]{null, "S", null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{User.Basic.class, User.Extended.class});
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Size.class, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "dateOfBirth"), TestUtil.names(methodName, "firstName"), TestUtil.names(methodName, "lastName"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="a")
    public void testUnexpectedType() throws Exception {
        String methodName = "setName";
        Address object = new Address();
        Method method = Address.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{"S"};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForObjectCausesException() throws Exception {
        Object object = null;
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters(object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForMethodCausesException() throws Exception {
        User object = new User();
        Method method = null;
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForParameterValuesCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = null;
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedForGroupsCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="c")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setFirstName", String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolationForCascadedValidation() throws Exception {
        String methodName = "setItem";
        OrderLine object = new OrderLine(null);
        Item leaf = new Item("foo");
        Method method = OrderLine.class.getMethod(methodName, Item.class);
        Object[] parameterValues = new Object[]{leaf};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)leaf);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"foo");
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }
}

