/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.BrokenCustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class DefaultParameterNameProviderTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClass(DefaultParameterNameProviderTest.class)).withClasses(BrokenCustomParameterNameProvider.class, User.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-namingparameters", id="a")
    public void testDefaultParameterProviderForMethod() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Object[] parameters = new Object[]{null, null};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Set<String> actualParameterNames = TestUtil.getParameterNames(constraintViolations);
        Set<String> expectedParameterNames = TestUtil.asSet("firstName", "lastName");
        Assert.assertEquals(actualParameterNames, expectedParameterNames);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-namingparameters", id="a")
    public void testDefaultParameterProviderForConstructor() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, String.class, Date.class);
        Object[] parameters = new Object[]{null, null, null};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameters, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        Set<String> actualParameterNames = TestUtil.getParameterNames(constraintViolations);
        Set<String> expectedParameterNames = TestUtil.asSet("firstName", "lastName", "dateOfBirth");
        Assert.assertEquals(actualParameterNames, expectedParameterNames);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="d")
    public void testGetDefaultParameterNameProviderFromConfiguration() throws Exception {
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Constructor constructor = User.class.getConstructor(String.class, String.class, Date.class);
        ParameterNameProvider defaultParameterNameProvider = TestUtil.getConfigurationUnderTest().getDefaultParameterNameProvider();
        Assert.assertNotNull((Object)defaultParameterNameProvider, (String)"getDefaultParameterNameProvider() must not return null");
        Assert.assertEquals((Collection)defaultParameterNameProvider.getParameterNames(constructor), Arrays.asList("firstName", "lastName", "dateOfBirth"), (String)"Wrong constructor parameter names returned by default provider");
        Assert.assertEquals((Collection)defaultParameterNameProvider.getParameterNames(method), Arrays.asList("firstName", "lastName"), (String)"Wrong method parameter names returned by default provider");
    }
}

